/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;

public class ItemLollipop
extends ItemGeneric {
    public ItemLollipop() {
        super("lollipop", ItemLollipop.getBuilder().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(2.0f).m_38766_().m_38765_().m_38767_()));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent(this.m_5671_(stack) + ".desc").m_6270_(StyleType.TOOLTIP_DESC));
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        short ordinal = NBTStackHelper.getShort(stack, "model_color", (short)-1);
        if (ordinal < 0 || ordinal >= ModelColor.values().length) {
            this.setColor(stack, ModelColor.getRandom());
        }
        return super.initCapabilities(stack, nbt);
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (stack.m_150930_((Item)this) & tintIndex == 0) {
            short ordinal;
            return 0xFF000000 | ((ordinal = NBTStackHelper.getShort((ItemStack)stack, (String)"model_color", (short)-1)) >= 0 && ordinal < ModelColor.values().length ? ModelColor.values()[ordinal] : ModelColor.RED).color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setShort(stack, "model_color", (short)modelColor.ordinal());
        }
        return stack;
    }

    public ItemStack getRandom() {
        return this.getRandom(1);
    }

    public ItemStack getRandom(int count) {
        return this.setColor(new ItemStack((ItemLike)this, count), ModelColor.getRandom());
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        super.m_5922_(stack, world, entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EffectHelper.addRandomEffect((Player)serverPlayer, 12000, true, false, false);
        }
        return stack;
    }

    @Override
    public String m_5524_() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public static enum ModelColor {
        YELLOW(14469140),
        PURPLE(5584316),
        GREEN(4174479),
        MAGENTA(11154876),
        RED(12334416);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.RANDOM.nextInt(ModelColor.values().length)];
        }
    }
}

