/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;

public final class SyncCooldownMessage {
    private final boolean isFullSync;
    private CooldownType type;
    private long worldTime;
    private ListTag cooldownTagList;

    public SyncCooldownMessage(CooldownType type, long worldTime) {
        this.isFullSync = false;
        this.type = type;
        this.worldTime = worldTime;
    }

    public SyncCooldownMessage(ListTag cooldownTagList) {
        this.isFullSync = true;
        this.cooldownTagList = cooldownTagList;
    }

    static SyncCooldownMessage fromBytes(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            CompoundTag compound = buf.m_130260_();
            return new SyncCooldownMessage(Optional.ofNullable(compound).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, "tb_cooldowns")).orElse(new ListTag()));
        }
        return new SyncCooldownMessage(CooldownType.values()[buf.readByte() & 0xFF], buf.readLong());
    }

    static void toBytes(SyncCooldownMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isFullSync);
        if (msg.isFullSync) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("tb_cooldowns", (Tag)msg.cooldownTagList);
            buf.m_130079_(compound);
        } else {
            buf.writeByte(msg.type.ordinal());
            buf.writeLong(msg.worldTime);
        }
    }

    public static class Handler {
        static void handle(SyncCooldownMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    if (message.isFullSync) {
                        CooldownHandler.INSTANCE.updateAllClientCooldowns(message.cooldownTagList);
                    } else {
                        CooldownHandler.INSTANCE.updateClientCooldown(message.type, message.worldTime);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

