/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public final class PerkJailer
extends Perk {
    public PerkJailer() {
        super("jailer", new ResourceLocation("tombstone", "textures/item/grave_key.png"));
    }

    @Override
    public int getLevelMax() {
        return 5 - (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() / 20;
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() == -1 || (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() == 100;
    }

    @Override
    public Component getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return new TextComponent("+" + level * 20 + "% ").m_7220_(this.getDescription());
        }
        if (level == actualLevel + 1) {
            return new TextComponent("+" + level * 20 + "%");
        }
        return TextComponent.f_131282_;
    }

    @Override
    public int getLevelBonus(Player player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public Component getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getText((Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() + levelWithBonus * 20);
    }
}

