/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.Registrable;
import ovh.corail.tombstone.tileentity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks {
    public static final EnumMap<GraveModel, Block> PLAYER_GRAVES = new EnumMap(Arrays.stream(GraveModel.values()).collect(Collectors.toMap(Function.identity(), BlockGrave::new)));
    public static final EnumMap<GraveModel, Block> DECORATIVE_GRAVES = new EnumMap(Arrays.stream(GraveModel.values()).collect(Collectors.toMap(Function.identity(), BlockDecorativeGrave::new)));
    public static final BlockEntityType<BlockEntityPlayerGrave> tile_grave = BlockEntityType.Builder.m_155273_(BlockEntityPlayerGrave::new, (Block[])PLAYER_GRAVES.values().toArray(new Block[0])).m_58966_(null);
    public static final BlockEntityType<BlockEntityDecorativeGrave> tile_decorative_grave = BlockEntityType.Builder.m_155273_(BlockEntityDecorativeGrave::new, (Block[])DECORATIVE_GRAVES.values().toArray(new Block[0])).m_58966_(null);
    @ObjectHolder(value="tombstone:dark_marble")
    public static final Block dark_marble = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:white_marble")
    public static final Block white_marble = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:dark_marble_slab")
    public static final Block dark_marble_slab = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:white_marble_slab")
    public static final Block white_marble_slab = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:dark_marble_stairs")
    public static final Block dark_marble_stairs = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:white_marble_stairs")
    public static final Block white_marble_stairs = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:dark_marble_wall")
    public static final Block dark_marble_wall = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:white_marble_wall")
    public static final Block white_marble_wall = Blocks.f_50016_;

    public static boolean isPlayerGrave(Block block) {
        return PLAYER_GRAVES.containsValue(block);
    }

    public static boolean isDecorativeGrave(Block block) {
        return DECORATIVE_GRAVES.containsValue(block);
    }

    public static boolean isAnyGrave(Block block) {
        return ModBlocks.isPlayerGrave(block) || ModBlocks.isDecorativeGrave(block);
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        PLAYER_GRAVES.forEach((m, g) -> Registrable.register(event.getRegistry(), g, m.m_7912_()));
        DECORATIVE_GRAVES.forEach((m, g) -> Registrable.register(event.getRegistry(), g, "decorative_" + m.m_7912_()));
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.DARK), "dark_marble");
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.WHITE), "white_marble");
        Registrable.register(event.getRegistry(), new SlabBlock(BlockGraveMarble.getBuilder()), "dark_marble_slab");
        Registrable.register(event.getRegistry(), new SlabBlock(BlockGraveMarble.getBuilder()), "white_marble_slab");
        Registrable.register(event.getRegistry(), new StairBlock(() -> dark_marble.m_49966_(), BlockGraveMarble.getBuilder()), "dark_marble_stairs");
        Registrable.register(event.getRegistry(), new StairBlock(() -> white_marble.m_49966_(), BlockGraveMarble.getBuilder()), "white_marble_stairs");
        Registrable.register(event.getRegistry(), new WallBlock(BlockGraveMarble.getBuilder()), "dark_marble_wall");
        Registrable.register(event.getRegistry(), new WallBlock(BlockGraveMarble.getBuilder()), "white_marble_wall");
    }

    @SubscribeEvent
    public static void registerItemBlock(RegistryEvent.Register<Item> event) {
        DECORATIVE_GRAVES.values().forEach(g -> Registrable.register(event.getRegistry(), new ItemBlockGrave((Block)g), Objects.requireNonNull(g.getRegistryName())));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble_slab, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble_slab.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble_slab, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble_slab.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble_stairs, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble_stairs.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble_stairs, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble_stairs.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble_wall, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble_wall.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble_wall, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble_wall.getRegistryName()));
    }

    @SubscribeEvent
    public static void registerBlockEntityTypes(RegistryEvent.Register<BlockEntityType<?>> event) {
        Registrable.register(event.getRegistry(), tile_decorative_grave, "tile_decorative_grave");
        Registrable.register(event.getRegistry(), tile_grave, "tile_grave");
    }
}

