/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.modify;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalcustomization.loader.CropLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public final class CropModifier {
    public static void modify(Crop crop, JsonObject json) throws JsonSyntaxException {
        if (json.has("name")) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            crop.setDisplayName((Component)new TextComponent(name));
        }
        if (json.has("tier")) {
            String tierId = GsonHelper.m_13906_((JsonObject)json, (String)"tier");
            CropTier tier = MysticalAgricultureAPI.getCropRegistry().getTierById(new ResourceLocation(tierId));
            if (tier == null) {
                throw new JsonSyntaxException("Invalid crop tier provided: " + tierId);
            }
            crop.setTier(tier);
        }
        if (json.has("type")) {
            String typeId = GsonHelper.m_13906_((JsonObject)json, (String)"type");
            CropType type = MysticalAgricultureAPI.getCropRegistry().getTypeById(new ResourceLocation(typeId));
            if (type == null) {
                throw new JsonSyntaxException("Invalid crop type provided: " + typeId);
            }
            crop.setType(type);
        }
        if (json.has("ingredient")) {
            LazyIngredient material;
            JsonObject ingredient = GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            if (ingredient.has("tag")) {
                String tag = GsonHelper.m_13906_((JsonObject)ingredient, (String)"tag");
                material = LazyIngredient.tag((String)tag);
            } else if (ingredient.has("item")) {
                String item = GsonHelper.m_13906_((JsonObject)ingredient, (String)"item");
                if (ingredient.has("nbt")) {
                    CompoundTag nbt = ParsingUtils.parseNBT(ingredient.get("nbt"));
                    material = LazyIngredient.item((String)item, (CompoundTag)nbt);
                } else {
                    material = LazyIngredient.item((String)item);
                }
            } else {
                throw new JsonSyntaxException("Ingredient must have either 'item' or 'tag' property");
            }
            crop.setCraftingMaterial(material);
        }
        if (json.has("baseSecondaryChance")) {
            double chance = GsonHelper.m_144784_((JsonObject)json, (String)"baseSecondaryChance");
            crop.setBaseSecondaryChance(chance);
        }
        if (json.has("enabled")) {
            boolean enabled = GsonHelper.m_13912_((JsonObject)json, (String)"enabled");
            crop.setEnabled(enabled);
        }
        if (json.has("crux")) {
            if (json.get("crux").isJsonNull()) {
                CropLoader.CRUX_MAP.put(crop, null);
            } else {
                String crux = GsonHelper.m_13906_((JsonObject)json, (String)"crux");
                CropLoader.CRUX_MAP.put(crop, new ResourceLocation(crux));
            }
        }
        if (json.has("glint")) {
            boolean glint = GsonHelper.m_13912_((JsonObject)json, (String)"glint");
            crop.setHasEffect(glint);
        }
        if (json.has("biomes")) {
            JsonArray biomes = GsonHelper.m_13933_((JsonObject)json, (String)"biomes");
            biomes.forEach(biome -> crop.addRequiredBiome(new ResourceLocation(biome.getAsString())));
        }
    }
}

