/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;

public class TerminalCraftingPlanStatic<I>
implements ITerminalCraftingPlan<I> {
    private final I id;
    private final List<ITerminalCraftingPlan<I>> dependencies;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private TerminalCraftingJobStatus status;
    private final long craftingQuantity;
    private final List<IPrototypedIngredient<?, ?>> storageIngredients;
    private final List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients;
    private String unlocalizedLabel;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanStatic(I id, List<ITerminalCraftingPlan<I>> dependencies, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, long craftingQuantity, List<IPrototypedIngredient<?, ?>> storageIngredients, List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients, String unlocalizedLabel, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.dependencies = dependencies;
        this.outputs = outputs;
        this.status = status;
        this.craftingQuantity = craftingQuantity;
        this.storageIngredients = storageIngredients;
        this.lastMissingIngredients = lastMissingIngredients;
        this.unlocalizedLabel = unlocalizedLabel;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<ITerminalCraftingPlan<I>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    @Override
    public long getCraftingQuantity() {
        return this.craftingQuantity;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getStorageIngredients() {
        return this.storageIngredients;
    }

    @Override
    public List<List<IPrototypedIngredient<?, ?>>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    @Override
    public String getUnlocalizedLabel() {
        return this.unlocalizedLabel;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabel = unlocalizedError;
    }

    public static <I> CompoundTag serialize(TerminalCraftingPlanStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("id", handler.serializeCraftingJobId(plan.getId()));
        ListTag dependencies = new ListTag();
        for (ITerminalCraftingPlan<I> iTerminalCraftingPlan : plan.getDependencies()) {
            dependencies.add((Object)TerminalCraftingPlanStatic.serialize((TerminalCraftingPlanStatic)iTerminalCraftingPlan, handler));
        }
        tag.m_128365_("dependencies", (Tag)dependencies);
        ListTag outputs = new ListTag();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            outputs.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.m_128365_("outputs", (Tag)outputs);
        tag.m_128405_("status", plan.getStatus().ordinal());
        tag.m_128356_("craftingQuantity", plan.getCraftingQuantity());
        ListTag listTag = new ListTag();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getStorageIngredients()) {
            listTag.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.m_128365_("storageIngredients", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (List<IPrototypedIngredient<?, ?>> lastMissingIngredient : plan.getLastMissingIngredients()) {
            ListTag lastMissingIngredientTag = new ListTag();
            for (IPrototypedIngredient<?, ?> prototypedIngredient : lastMissingIngredient) {
                lastMissingIngredientTag.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)prototypedIngredient)));
            }
            listTag2.add((Object)lastMissingIngredientTag);
        }
        tag.m_128365_("lastMissingIngredients", (Tag)listTag2);
        tag.m_128359_("unlocalizedLabel", plan.getUnlocalizedLabel());
        tag.m_128356_("tickDuration", plan.getTickDuration());
        tag.m_128405_("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.m_128359_("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanStatic<I> deserialize(CompoundTag tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.m_128441_("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.m_128425_("dependencies", 9)) {
            throw new IllegalArgumentException("Could not find a dependencies entry in the given tag");
        }
        if (!tag.m_128425_("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.m_128425_("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.m_128425_("craftingQuantity", 4)) {
            throw new IllegalArgumentException("Could not find a craftingQuantity entry in the given tag");
        }
        if (!tag.m_128425_("storageIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a storageIngredients entry in the given tag");
        }
        if (!tag.m_128425_("lastMissingIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a lastMissingIngredients entry in the given tag");
        }
        if (!tag.m_128425_("unlocalizedLabel", 8)) {
            throw new IllegalArgumentException("Could not find a unlocalizedLabel entry in the given tag");
        }
        if (!tag.m_128425_("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.m_128425_("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.m_128423_("id"));
        ListTag dependenciesTag = tag.m_128437_("dependencies", 10);
        ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)dependenciesTag.size());
        for (Tag nbtBase : dependenciesTag) {
            dependencies.add(TerminalCraftingPlanStatic.deserialize((CompoundTag)nbtBase, handler));
        }
        ListTag outputsTag = tag.m_128437_("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.size());
        for (Tag nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.m_128451_("status")];
        long craftingQuantity = tag.m_128454_("craftingQuantity");
        ListTag storageIngredientsTag = tag.m_128437_("storageIngredients", 10);
        ArrayList storageIngredients = Lists.newArrayListWithExpectedSize((int)storageIngredientsTag.size());
        for (Tag nbtBase : storageIngredientsTag) {
            storageIngredients.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)nbtBase)));
        }
        ListTag lastMissingIngredientsTag = tag.m_128437_("lastMissingIngredients", 9);
        ArrayList lastMissingIngredients = Lists.newArrayListWithExpectedSize((int)lastMissingIngredientsTag.size());
        for (Tag nbtBase : lastMissingIngredientsTag) {
            ListTag list = (ListTag)nbtBase;
            ArrayList lastMissingIngredient = Lists.newArrayListWithExpectedSize((int)list.size());
            for (Tag base : list) {
                lastMissingIngredient.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)base)));
            }
            lastMissingIngredients.add(lastMissingIngredient);
        }
        String unlocalizedLabel = tag.m_128461_("unlocalizedLabel");
        long tickDuration = tag.m_128454_("tickDuration");
        int channel = tag.m_128451_("channel");
        String initiatorName = null;
        if (tag.m_128425_("initiatorName", 8)) {
            initiatorName = tag.m_128461_("initiatorName");
        }
        return new TerminalCraftingPlanStatic<I>(id, dependencies, outputs, status, craftingQuantity, storageIngredients, lastMissingIngredients, unlocalizedLabel, tickDuration, channel, initiatorName);
    }
}

