/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;

public class ContainerScreenTerminalStorageCraftingOptionAmount<L, C extends ContainerTerminalStorageCraftingOptionAmountBase<L>>
extends ContainerScreenExtended<C> {
    public static int OUTPUT_SLOT_X = 135;
    public static int OUTPUT_SLOT_Y = 15;
    private final List<IPrototypedIngredient<?, ?>> outputs = Lists.newArrayList();
    private WidgetNumberField numberField = null;
    private WidgetScrollBar scrollBar;
    private int firstRow;
    private ButtonText nextButton;

    public ContainerScreenTerminalStorageCraftingOptionAmount(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
        ITerminalCraftingOption<?> option = ((ContainerTerminalStorageCraftingOptionAmountBase)this.m_6262_()).getCraftingOptionGuiData().getCraftingOption().getCraftingOption();
        for (IngredientComponent<?, ?> outputComponent : option.getOutputComponents()) {
            for (Object output : option.getOutputs(outputComponent)) {
                this.outputs.add((IPrototypedIngredient<?, ?>)new PrototypedIngredient(outputComponent, output, null));
            }
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_option_amount.png");
    }

    public int getBaseXSize() {
        return 178;
    }

    public int getBaseYSize() {
        return 162;
    }

    public void m_7856_() {
        super.m_7856_();
        this.numberField = new WidgetNumberField(Minecraft.m_91087_().f_91062_, this.f_97735_ + 25, this.f_97736_ + 36, 53, 14, true, (Component)new TranslatableComponent("gui.integratedterminals.amount"), true);
        this.numberField.setPositiveOnly(true);
        this.numberField.m_94199_(5);
        this.numberField.setMaxValue(10000);
        this.numberField.setMinValue(1);
        this.numberField.m_94194_(true);
        this.numberField.m_94202_(0xFFFFFF);
        this.numberField.m_94190_(true);
        this.numberField.m_94144_("1");
        this.f_169369_.add(this.numberField);
        this.scrollBar = new WidgetScrollBar(this.f_97735_ + 153, this.f_97736_ + 15, 54, (Component)new TranslatableComponent("gui.cyclopscore.scrollbar"), this::setFirstRow, 3);
        this.scrollBar.setTotalRows(this.outputs.size() - 1);
        this.m_7787_((GuiEventListener)this.scrollBar);
        this.m_142416_((GuiEventListener)new ButtonChangeQuantity(this.f_97735_ + 5, this.f_97736_ + 10, 10, this::buttonChangeQuantity));
        this.m_142416_((GuiEventListener)new ButtonChangeQuantity(this.f_97735_ + 5, this.f_97736_ + 55, -10, this::buttonChangeQuantity));
        this.m_142416_((GuiEventListener)new ButtonChangeQuantity(this.f_97735_ + 48, this.f_97736_ + 10, 100, this::buttonChangeQuantity));
        this.m_142416_((GuiEventListener)new ButtonChangeQuantity(this.f_97735_ + 48, this.f_97736_ + 55, -100, this::buttonChangeQuantity));
        this.m_142416_((GuiEventListener)new ButtonChangeQuantity(this.f_97735_ + 91, this.f_97736_ + 10, 1000, this::buttonChangeQuantity));
        this.m_142416_((GuiEventListener)new ButtonChangeQuantity(this.f_97735_ + 91, this.f_97736_ + 55, -1000, this::buttonChangeQuantity));
        this.nextButton = new ButtonText(this.f_97735_ + 81, this.f_97736_ + 33, 50, 20, (Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.step.next"), (Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.step.next").m_130940_(ChatFormatting.YELLOW), bb -> this.calculateCraftingJob(), true);
        this.m_142416_((GuiEventListener)this.nextButton);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        return this.numberField.m_5534_(typedChar, keyCode) || super.m_5534_(typedChar, keyCode);
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        if (typedChar == 256) {
            this.returnToTerminalStorage();
            return true;
        }
        if (typedChar == 257 || typedChar == 335) {
            this.calculateCraftingJob();
            return true;
        }
        return this.numberField.m_7933_(typedChar, keyCode, modifiers) || super.m_7933_(typedChar, keyCode, modifiers);
    }

    private void returnToTerminalStorage() {
        CraftingOptionGuiData data = ((ContainerTerminalStorageCraftingOptionAmountBase)this.m_6262_()).getCraftingOptionGuiData();
        data.getLocation().openContainerFromClient(data);
    }

    public void buttonChangeQuantity(Button button) {
        if (button instanceof ButtonChangeQuantity) {
            int diff = ((ButtonChangeQuantity)button).getDiff();
            this.setAmount(this.getAmount() + diff);
        }
    }

    private void calculateCraftingJob() {
        CraftingOptionGuiData craftingOptionData = ((ContainerTerminalStorageCraftingOptionAmountBase)this.m_6262_()).getCraftingOptionGuiData().copyWithAmount(this.getAmount());
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket(craftingOptionData));
    }

    protected <T, M> void drawInstance(PoseStack matrixStack, IngredientComponent<T, M> ingredientComponent, T instance, int x, int y, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        long quantity = ingredientComponent.getMatcher().getQuantity(instance) * (long)this.getAmount();
        ((IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find ingredient terminal storage handler"))).drawInstance(matrixStack, ingredientComponent.getMatcher().withQuantity(instance, quantity), quantity, GuiHelpers.quantityToScaledString((long)quantity), (AbstractContainerScreen)this, layer, partialTick, x, y, mouseX, mouseY, null);
    }

    private int getAmount() {
        try {
            return this.numberField.getInt();
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private void setAmount(int amount) {
        this.numberField.m_94144_(Integer.toString(this.numberField.validateNumber(amount)));
    }

    protected void drawOutputSlots(PoseStack matrixStack, int x, int y, float partialTicks, int mouseX, int mouseY, ContainerScreenTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (IPrototypedIngredient<?, ?> output : this.outputs.subList(this.firstRow, Math.min(this.outputs.size(), this.firstRow + this.scrollBar.getVisibleRows()))) {
            this.drawInstance(matrixStack, output.getComponent(), output.getPrototype(), x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.numberField.m_6303_(matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_, partialTicks);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawOutputSlots(matrixStack, this.f_97735_, this.f_97736_, partialTicks, mouseX - this.f_97735_, mouseY - this.f_97736_, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.drawOutputSlots(matrixStack, 0, 0, 0.0f, mouseX, mouseY, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        return this.m_7222_() != null && this.m_7282_() && mouseButton == 0 && this.m_7222_().m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public class ButtonChangeQuantity
    extends ButtonExtended {
        private final int diff;

        public ButtonChangeQuantity(int x, int y, int diff, Button.OnPress pressCallback) {
            super(x, y, 40, 20, (Component)new TextComponent((diff < 0 ? "- " : "+ ") + Integer.toString(Math.abs(diff))), pressCallback, true);
            this.diff = diff;
        }

        protected void drawButtonInner(PoseStack matrixStack, int i, int j) {
            int color = 0xE0E0E0;
            if (!this.f_93623_) {
                color = 0xA0A0A0;
            } else if (this.f_93622_) {
                color = 0xFFFFA0;
            }
            ButtonChangeQuantity.m_93215_((PoseStack)matrixStack, (Font)((ContainerScreenTerminalStorageCraftingOptionAmount)ContainerScreenTerminalStorageCraftingOptionAmount.this).f_96541_.f_91062_, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)color);
        }

        public int getDiff() {
            return this.diff;
        }
    }
}

