/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.client.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class CraftingJobGuiData {
    private final BlockPos pos;
    private final Direction side;
    private final int channel;
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final Object craftingJob;

    public CraftingJobGuiData(BlockPos pos, Direction side, int channel, ITerminalStorageTabIngredientCraftingHandler handler, Object craftingJob) {
        this.pos = pos;
        this.side = side;
        this.channel = channel;
        this.handler = handler;
        this.craftingJob = craftingJob;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public int getChannel() {
        return this.channel;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public Object getCraftingJob() {
        return this.craftingJob;
    }

    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(this.pos);
        packetBuffer.writeInt(this.side.ordinal());
        packetBuffer.writeInt(this.channel);
        packetBuffer.m_130070_(this.handler.getId().toString());
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("id", this.handler.serializeCraftingJobId(this.craftingJob));
        packetBuffer.m_130079_(tag);
    }

    public static CraftingJobGuiData readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        BlockPos pos = packetBuffer.m_130135_();
        Direction side = Direction.values()[packetBuffer.readInt()];
        int channel = packetBuffer.readInt();
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(packetBuffer.m_130136_(Short.MAX_VALUE)));
        Object craftingJob = handler.deserializeCraftingJobId(packetBuffer.m_130260_().m_128423_("id"));
        return new CraftingJobGuiData(pos, side, channel, handler, craftingJob);
    }
}

