/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.inventory.InventoryCraftingDirtyable;
import org.cyclops.integratedterminals.inventory.SlotCraftingAutoRefill;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetResult;

public class TerminalStorageTabIngredientComponentItemStackCraftingCommon
extends TerminalStorageTabIngredientComponentCommon<ItemStack, Integer> {
    private CraftingContainer inventoryCrafting;
    private ResultContainer inventoryCraftResult;
    private ResultSlot slotCrafting;
    private List<Slot> slots;
    private TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill = TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType.STORAGE;

    public TerminalStorageTabIngredientComponentItemStackCraftingCommon(ContainerTerminalStorageBase containerTerminalStorage, ResourceLocation name, IngredientComponent<ItemStack, Integer> ingredientComponent) {
        super(containerTerminalStorage, name, ingredientComponent);
    }

    public static int getCraftingResultSlotIndex(AbstractContainerMenu container, ResourceLocation name) {
        ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)container).getTabCommon(name.toString());
        TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
        return tabCommonCrafting.getSlotCrafting().f_40219_;
    }

    @Override
    public List<Slot> loadSlots(AbstractContainerMenu container, int startIndex, Player player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventoryOptional) {
        ITerminalStorageTabCommon.IVariableInventory variableInventory = variableInventoryOptional.get();
        this.slots = Lists.newArrayListWithCapacity((int)10);
        final IDirtyMarkListener dirtyListener = () -> this.updateCraftingResult(player, container, variableInventory);
        this.inventoryCraftResult = new ResultContainer(){

            public void m_6596_() {
                dirtyListener.onDirty();
                super.m_6596_();
            }
        };
        this.inventoryCrafting = new InventoryCraftingDirtyable(container, 3, 3, dirtyListener);
        this.slotCrafting = new SlotCraftingAutoRefill(player, this.inventoryCrafting, (Container)this.inventoryCraftResult, 0, 115, 76, this, (TerminalStorageTabIngredientComponentServer)((ContainerTerminalStorageBase)container).getTabServer(this.getName().toString()), (ContainerTerminalStorageBase)container);
        this.slots.add((Slot)this.slotCrafting);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.slots.add(new Slot((Container)this.inventoryCrafting, j + i * 3, 31 + j * 18, 58 + i * 18));
            }
        }
        NonNullList<ItemStack> tabItems = variableInventory.getNamedInventory(this.getName().toString());
        if (tabItems != null) {
            int i = 0;
            for (ItemStack tabItem : tabItems) {
                if (i == 0) {
                    this.inventoryCraftResult.m_6836_(i++, tabItem);
                    continue;
                }
                this.inventoryCrafting.m_6836_(i++ - 1, tabItem);
            }
        }
        ArrayList returnSlots = Lists.newArrayList(this.slots);
        for (Triple<Slot, Integer, Integer> slot : ((ContainerTerminalStorageBase)container).getTabSlots(this.ingredientComponent.getName().toString())) {
            returnSlots.add((Slot)slot.getLeft());
        }
        return returnSlots;
    }

    public CraftingContainer getInventoryCrafting() {
        return this.inventoryCrafting;
    }

    public ResultContainer getInventoryCraftResult() {
        return this.inventoryCraftResult;
    }

    public ResultSlot getSlotCrafting() {
        return this.slotCrafting;
    }

    public TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType getAutoRefill() {
        return this.autoRefill;
    }

    public void setAutoRefill(TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill) {
        this.autoRefill = autoRefill;
    }

    public void updateCraftingResult(Player player, AbstractContainerMenu container, ITerminalStorageTabCommon.IVariableInventory variableInventory) {
        if (!player.f_19853_.f_46443_) {
            ServerPlayer entityplayermp = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            CraftingRecipe recipe = CraftingHelpers.findServerRecipe((RecipeType)RecipeType.f_44107_, (Container)this.inventoryCrafting, (Level)player.f_19853_).orElse(null);
            if (recipe != null && (recipe.m_5598_() || !player.f_19853_.m_46469_().m_46207_(GameRules.f_46151_) || entityplayermp.m_8952_().m_12709_((Recipe)recipe))) {
                this.inventoryCraftResult.m_6029_((Recipe)recipe);
                itemstack = recipe.m_5874_((Container)this.inventoryCrafting);
            }
            this.inventoryCraftResult.m_6836_(0, itemstack);
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetResult(this.getName().toString(), itemstack), (ServerPlayer)player);
        }
        NonNullList latestItems = NonNullList.m_122779_();
        for (Slot slot : this.slots) {
            latestItems.add((Object)slot.m_7993_());
        }
        variableInventory.setNamedInventory(this.getName().toString(), (NonNullList<ItemStack>)latestItems);
    }
}

