/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonFilterCrafting<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentCommon<T, ?>, ButtonImage> {
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private FilterType active;

    public TerminalButtonFilterCrafting(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "filter_crafting";
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = FilterType.values()[data.m_128451_("active")];
        } else {
            this.active = FilterType.ALL;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ButtonImage createButton(int x, int y) {
        return new ButtonImage(x, y, (Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.craftinggrid.clear"), b -> {}, new IImage[]{this.active == FilterType.ALL ? Images.BUTTON_BACKGROUND_INACTIVE : Images.BUTTON_BACKGROUND_ACTIVE, this.active.getImage()});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, TerminalStorageTabIngredientComponentCommon<T, ?> commomTab, ButtonImage guiButton, int channel, int mouseButton) {
        this.active = mouseButton == 0 ? FilterType.values()[(this.active.ordinal() + 1) % FilterType.values().length] : FilterType.ALL;
        CompoundTag data = new CompoundTag();
        data.m_128405_("active", this.active.ordinal());
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (Tag)data);
        clientTab.resetFilteredIngredientsViews(channel);
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.crafting.filter";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)new TranslatableComponent("gui.integratedterminals.terminal_storage.crafting.filter.info"));
        lines.add((Component)new TranslatableComponent(this.active.getLabel()));
    }

    public Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<T>> getEffectiveFilter() {
        return this.active.getFilter();
    }

    public static enum FilterType {
        ALL((IImage)Images.BUTTON_MIDDLE_FILTER_CRAFTING_ALL, "gui.integratedterminals.terminal_storage.crafting.filter.type.all", i -> true),
        STORAGE((IImage)Images.BUTTON_MIDDLE_FILTER_CRAFTING_STORAGE, "gui.integratedterminals.terminal_storage.crafting.filter.type.storage", i -> i.getCraftingOption() == null),
        CRAFTABLE((IImage)Images.BUTTON_MIDDLE_FILTER_CRAFTING_CRAFTABLE, "gui.integratedterminals.terminal_storage.crafting.filter.type.craftable", i -> i.getCraftingOption() != null);

        @Nullable
        private final IImage image;
        private final String label;
        private final Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<?>> filter;

        private FilterType(IImage image, String label, Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<?>> filter) {
            this.image = image;
            this.label = label;
            this.filter = filter;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }

        public Predicate<TerminalStorageTabIngredientComponentClient.InstanceWithMetadata<?>> getFilter() {
            return this.filter;
        }
    }
}

