/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.location;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountItem;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanItem;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemOpenPacket;

public class TerminalStorageLocationItem
implements ITerminalStorageLocation<Pair<InteractionHand, Integer>> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integratedterminals", "item");
    }

    @Override
    public <T, M> void openContainerFromClient(CraftingOptionGuiData<T, M, Pair<InteractionHand, Integer>> craftingOptionGuiData) {
        Pair<InteractionHand, Integer> slot = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientItemOpenPacket.send(slot, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerFromServer(CraftingOptionGuiData<T, M, Pair<InteractionHand, Integer>> craftingOptionGuiData, Level world, ServerPlayer player) {
        Pair<InteractionHand, Integer> slot = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientItemOpenPacket.openServer(world, slot, player, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerCraftingPlan(final CraftingOptionGuiData<T, M, Pair<InteractionHand, Integer>> craftingOptionGuiData, Level world, ServerPlayer player) {
        final Pair<InteractionHand, Integer> location = craftingOptionGuiData.getLocationInstance();
        MenuProvider containerProvider = new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStorageCraftingPlanItem(id, playerInventory, (Integer)location.getRight(), (InteractionHand)location.getLeft(), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> {
            packetBuffer.writeInt(((Integer)location.getRight()).intValue());
            packetBuffer.writeBoolean(location.getLeft() == InteractionHand.MAIN_HAND);
            craftingOptionGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    @Override
    public <T, M> void openContainerCraftingOptionAmount(final CraftingOptionGuiData<T, M, Pair<InteractionHand, Integer>> craftingOptionGuiData, Level world, ServerPlayer player) {
        final Pair<InteractionHand, Integer> location = craftingOptionGuiData.getLocationInstance();
        MenuProvider containerProvider = new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStorageCraftingOptionAmountItem(id, playerInventory, (Integer)location.getRight(), (InteractionHand)location.getLeft(), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> {
            packetBuffer.writeInt(((Integer)location.getRight()).intValue());
            packetBuffer.writeBoolean(location.getLeft() == InteractionHand.MAIN_HAND);
            craftingOptionGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    @Override
    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer, Pair<InteractionHand, Integer> location) {
        packetBuffer.m_130070_(((InteractionHand)location.getLeft()).name());
        packetBuffer.writeInt(((Integer)location.getRight()).intValue());
    }

    @Override
    public Pair<InteractionHand, Integer> readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        return Pair.of((Object)InteractionHand.valueOf((String)packetBuffer.m_130136_(Short.MAX_VALUE)), (Object)packetBuffer.readInt());
    }
}

