/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortable;

public class ContainerTerminalStorageItem
extends ContainerTerminalStorageBase<Pair<InteractionHand, Integer>> {
    private final int itemIndex;
    private final InteractionHand hand;

    public ContainerTerminalStorageItem(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, ItemInventoryContainer.readItemIndex((FriendlyByteBuf)packetBuffer), ItemInventoryContainer.readHand((FriendlyByteBuf)packetBuffer), packetBuffer.readBoolean() ? Optional.of(ContainerTerminalStorageBase.InitTabData.readFromPacketBuffer(packetBuffer)) : Optional.empty(), TerminalStorageState.readFromPacketBuffer(packetBuffer));
        this.getGuiState().setDirtyMarkListener(this::sendGuiStateToServer);
    }

    public ContainerTerminalStorageItem(int id, Inventory playerInventory, int itemIndex, InteractionHand hand, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        this(RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_ITEM, id, playerInventory, itemIndex, hand, initTabData, terminalStorageState);
    }

    public ContainerTerminalStorageItem(@Nullable MenuType<?> type, int id, Inventory playerInventory, int itemIndex, InteractionHand hand, Optional<ContainerTerminalStorageBase.InitTabData> initTabData, TerminalStorageState terminalStorageState) {
        super(type, id, playerInventory, initTabData, terminalStorageState, ContainerTerminalStorageItem.getNetworkFromItem(InventoryHelpers.getItemFromIndex((Player)playerInventory.f_35978_, (int)itemIndex, (InteractionHand)hand)), ContainerTerminalStorageItem.getVariableInventoryFromItem(InventoryHelpers.getItemFromIndex((Player)playerInventory.f_35978_, (int)itemIndex, (InteractionHand)hand)));
        this.itemIndex = itemIndex;
        this.hand = hand;
    }

    public static Optional<INetwork> getNetworkFromItem(ItemStack itemStack) {
        if (MinecraftHelpers.isClientSideThread()) {
            return Optional.empty();
        }
        int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
        if (groupId < 0) {
            return Optional.empty();
        }
        for (PartPos pos : PartTypeConnectorOmniDirectional.LOADED_GROUPS.getPositions(groupId)) {
            LazyOptional network = NetworkHelpers.getNetwork((PartPos)pos);
            if (!network.isPresent()) continue;
            return network.map(a -> a);
        }
        return Optional.empty();
    }

    public static Optional<ITerminalStorageTabCommon.IVariableInventory> getVariableInventoryFromItem(ItemStack itemStack) {
        return Optional.of(ItemTerminalStoragePortable.getVariableInventory(itemStack));
    }

    public ItemStack getItemStack(Player player) {
        return InventoryHelpers.getItemFromIndex((Player)player, (int)this.itemIndex, (InteractionHand)this.hand);
    }

    public boolean m_6875_(Player playerIn) {
        ItemStack item = this.getItemStack(this.player);
        return item != null && item.m_41720_() == RegistryEntries.ITEM_TERMINAL_STORAGE_PORTABLE;
    }

    @Override
    public ITerminalStorageLocation<Pair<InteractionHand, Integer>> getLocation() {
        return TerminalStorageLocations.ITEM;
    }

    @Override
    public Pair<InteractionHand, Integer> getLocationInstance() {
        return Pair.of((Object)this.hand, (Object)this.itemIndex);
    }

    @Override
    public void onVariableContentsUpdated(INetwork network, IVariable<?> variable) {
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y){

            public boolean m_8010_(Player playerIn) {
                return super.m_8010_(playerIn) && ContainerTerminalStorageItem.this.itemIndex != this.f_40219_;
            }
        };
    }
}

