/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class ItemTerminalStoragePortable
extends ItemGui {
    public static String NBT_KEY_GROUP = "integratedterminals:groupKey";
    public static String NBT_KEY_NAMED_INVENTORIES = "integratedterminals:namedInventories";
    public static String NBT_KEY_STATES = "integratedterminals:terminalStorageStates";

    public ItemTerminalStoragePortable(Item.Properties properties) {
        super(properties);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, int itemIndex, InteractionHand hand) {
        if (world.m_5776_()) {
            super.openGuiForItemIndex(world, player, itemIndex, hand);
        } else {
            ItemStack itemStack = InventoryHelpers.getItemFromIndex((Player)player, (int)itemIndex, (InteractionHand)hand);
            int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
            if (groupId >= 0) {
                Optional<INetwork> network = ContainerTerminalStorageItem.getNetworkFromItem(itemStack);
                if (network.isPresent()) {
                    super.openGuiForItemIndex(world, player, itemIndex, hand);
                } else {
                    player.m_5661_((Component)new TranslatableComponent("item.integratedterminals.terminal_storage_portable.status.invalid_network"), true);
                }
            } else {
                player.m_5661_((Component)new TranslatableComponent("item.integratedterminals.terminal_storage_portable.status.no_network"), true);
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        PartPos partPos;
        PartHelpers.PartStateHolder partStateHolder;
        if (!context.m_43725_().m_5776_() && (partStateHolder = PartHelpers.getPart((PartPos)(partPos = PartPos.of((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_())))) != null && partStateHolder.getPart() == PartTypes.CONNECTOR_OMNI) {
            PartTypeConnectorOmniDirectional.State state = (PartTypeConnectorOmniDirectional.State)partStateHolder.getState();
            ItemTerminalStoragePortable.setGroupId(stack, state.getGroupId());
            context.m_43723_().m_5661_((Component)new TranslatableComponent("item.integratedterminals.terminal_storage_portable.status.linked"), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, int itemIndex, InteractionHand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, itemStack.m_41786_(), (id, playerInventory, slot, hand1) -> new ContainerTerminalStorageItem(id, playerInventory, slot, hand1, Optional.empty(), ItemTerminalStoragePortable.getTerminalStorageState(InventoryHelpers.getItemFromIndex((Player)playerEntity, (int)itemIndex, (InteractionHand)hand), playerEntity, itemIndex, hand)));
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerTerminalStorageItem.class;
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, int itemIndex, InteractionHand hand) {
        super.writeExtraGuiData(packetBuffer, world, player, itemIndex, hand);
        packetBuffer.writeBoolean(false);
        ItemTerminalStoragePortable.getTerminalStorageState(InventoryHelpers.getItemFromIndex((Player)player, (int)itemIndex, (InteractionHand)hand), (Player)player, itemIndex, hand).writeToPacketBuffer(packetBuffer);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.m_41720_() != newStack.m_41720_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int groupId = ItemTerminalStoragePortable.getGroupId(stack);
        if (groupId >= 0) {
            tooltip.add((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.monodirectionalconnector.group", new Object[]{groupId}));
        }
    }

    public static int getGroupId(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null || !tag.m_128425_(NBT_KEY_GROUP, 3)) {
            return -1;
        }
        return tag.m_128451_(NBT_KEY_GROUP);
    }

    public static void setGroupId(ItemStack itemStack, int groupId) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_(NBT_KEY_GROUP, groupId);
    }

    public static ITerminalStorageTabCommon.IVariableInventory getVariableInventory(ItemStack itemStack) {
        CompoundTag tagRoot = itemStack.m_41784_();
        if (!tagRoot.m_128425_(NBT_KEY_NAMED_INVENTORIES, 10)) {
            tagRoot.m_128365_(NBT_KEY_NAMED_INVENTORIES, (Tag)new CompoundTag());
        }
        final CompoundTag tagInventories = tagRoot.m_128469_(NBT_KEY_NAMED_INVENTORIES);
        return new ITerminalStorageTabCommon.IVariableInventory(){

            @Override
            public NonNullList<ItemStack> getNamedInventory(String name) {
                CompoundTag tag = tagInventories.m_128469_(name);
                NonNullList list = NonNullList.m_122780_((int)tag.m_128451_("itemCount"), (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
                return list;
            }

            @Override
            public void setNamedInventory(String name, NonNullList<ItemStack> inventory) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("tabName", name);
                tag.m_128405_("itemCount", inventory.size());
                ContainerHelper.m_18973_((CompoundTag)tag, inventory);
                tagInventories.m_128365_(name, (Tag)tag);
            }
        };
    }

    public static TerminalStorageState getTerminalStorageState(ItemStack itemStack, Player player, int slot, InteractionHand hand) {
        CompoundTag tagRoot = itemStack.m_41784_();
        if (!tagRoot.m_128425_(NBT_KEY_STATES, 10)) {
            tagRoot.m_128365_(NBT_KEY_STATES, (Tag)new CompoundTag());
        }
        CompoundTag tagStates = tagRoot.m_128469_(NBT_KEY_STATES);
        String playerKey = player.m_142081_().toString();
        Wrapper stateWrapped = new Wrapper();
        IDirtyMarkListener dirtyMarkListener = () -> tagStates.m_128365_(playerKey, (Tag)((TerminalStorageState)stateWrapped.get()).getTag());
        if (!tagStates.m_128425_(playerKey, 10)) {
            TerminalStorageState state = TerminalStorageState.getPlayerDefault(player, dirtyMarkListener);
            stateWrapped.set((Object)state);
            tagStates.m_128365_(playerKey, (Tag)state.getTag());
            return state;
        }
        TerminalStorageState state = new TerminalStorageState(tagStates.m_128469_(playerKey), dirtyMarkListener);
        stateWrapped.set((Object)state);
        return state;
    }
}

