/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortable;

public class TerminalStorageIngredientItemOpenPacket
extends PacketCodec {
    @CodecField
    private int slot;
    @CodecField
    private String handName;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;

    public TerminalStorageIngredientItemOpenPacket() {
    }

    public TerminalStorageIngredientItemOpenPacket(Pair<InteractionHand, Integer> location, String tabName, int channel) {
        this.slot = (Integer)location.getRight();
        this.handName = ((InteractionHand)location.getLeft()).name();
        this.tabName = tabName;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        TerminalStorageIngredientItemOpenPacket.openServer(world, (Pair<InteractionHand, Integer>)Pair.of((Object)InteractionHand.valueOf((String)this.handName), (Object)this.slot), player, this.tabName, this.channel);
    }

    public static void openServer(Level world, final Pair<InteractionHand, Integer> location, ServerPlayer player, String tabName, int channel) {
        final ContainerTerminalStorageBase.InitTabData initData = new ContainerTerminalStorageBase.InitTabData(tabName, channel);
        final TerminalStorageState terminalStorageState = ItemTerminalStoragePortable.getTerminalStorageState(InventoryHelpers.getItemFromIndex((Player)player, (int)((Integer)location.getRight()), (InteractionHand)((InteractionHand)location.getLeft())), (Player)player, (Integer)location.getRight(), (InteractionHand)location.getLeft());
        MenuProvider containerProvider = new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStorageItem(id, playerInventory, (Integer)location.getRight(), (InteractionHand)location.getLeft(), Optional.of(initData), terminalStorageState);
            }
        };
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> {
            packetBuffer.writeInt(((Integer)location.getRight()).intValue());
            packetBuffer.writeBoolean(location.getLeft() == InteractionHand.MAIN_HAND);
            packetBuffer.writeBoolean(true);
            initData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
            terminalStorageState.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    public static void send(Pair<InteractionHand, Integer> location, String tabName, int channel) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemOpenPacket(location, tabName, channel));
    }
}

