/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBee;
import cy.jdkdigital.productivebees.util.ColorUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BeeBodyLayer
extends RenderLayer<ProductiveBee, ProductiveBeeModel<ProductiveBee>> {
    private final String modelType;
    private final EntityModel<ProductiveBee> model;
    private boolean isChristmas;

    public BeeBodyLayer(RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>> rendererIn, ModelPart layer, String modelType, boolean isChristmas) {
        super(rendererIn);
        this.modelType = modelType;
        this.model = new ProductiveBeeModel(layer, modelType);
        this.isChristmas = isChristmas;
    }

    public void render(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getRenderer().equals(this.modelType) && !entity.m_20145_()) {
            ((ProductiveBeeModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (entity instanceof ConfigurableBee && ((ConfigurableBee)entity).isTranslucent()) {
                VertexConsumer vertexBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)entity)));
                this.model.m_7695_(matrixStackIn, vertexBuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                BeeBodyLayer.m_117376_(this.model, (ResourceLocation)this.m_117347_((Entity)entity), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (entity.getColor(0) >= 0) {
                if (entity instanceof ConfigurableBee && ((ConfigurableBee)entity).hasBeeTexture()) {
                    if (this.modelType.equals("default_crystal") && ((ConfigurableBee)entity).useGlowLayer()) {
                        this.renderCrystalLayer(matrixStackIn, bufferIn, packedLightIn, entity);
                    }
                    return;
                }
                this.renderColoredLayers(matrixStackIn, bufferIn, packedLightIn, entity);
            }
            if (entity.m_27856_() && !entity.hasConverted()) {
                this.renderNectarLayer(matrixStackIn, bufferIn, packedLightIn, entity);
            }
            this.renderChristmasHat(matrixStackIn, bufferIn, packedLightIn, entity);
            this.renderSaddle(matrixStackIn, bufferIn, packedLightIn, entity);
        }
    }

    private void renderColoredLayers(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        float[] primaryColor = ColorUtil.getComponents(entity.getColor(0));
        ResourceLocation location = new ResourceLocation("productivebees", "textures/entity/bee/base/" + this.modelType + "/primary.png");
        BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)primaryColor[0], (float)primaryColor[1], (float)primaryColor[2]);
        float[] secondaryColor = ColorUtil.getComponents(entity.getColor(1));
        ResourceLocation abdomenLocation = new ResourceLocation("productivebees", "textures/entity/bee/base/" + this.modelType + "/abdomen.png");
        BeeBodyLayer.m_117376_(this.model, (ResourceLocation)abdomenLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)secondaryColor[0], (float)secondaryColor[1], (float)secondaryColor[2]);
        if (this.modelType.equals("default_crystal")) {
            this.renderCrystalLayer(matrixStackIn, bufferIn, packedLightIn, entity);
        } else if (this.modelType.equals("default_foliage") || this.modelType.equals("default_shell")) {
            float[] color = primaryColor;
            if (entity instanceof ConfigurableBee) {
                color = ((ConfigurableBee)entity).getTertiaryColor();
            }
            ResourceLocation foliageLocation = new ResourceLocation("productivebees", "textures/entity/bee/base/" + this.modelType + "/crystals.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)foliageLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)color[0], (float)color[1], (float)color[2]);
        }
    }

    private void renderCrystalLayer(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, ProductiveBee entity) {
        boolean useGlowLayer;
        float[] color = ColorUtil.getComponents(entity.getColor(0));
        boolean bl = useGlowLayer = !entity.getRenderStatic();
        if (entity instanceof ConfigurableBee) {
            color = ((ConfigurableBee)entity).getTertiaryColor();
            useGlowLayer = useGlowLayer && ((ConfigurableBee)entity).useGlowLayer();
        }
        ResourceLocation crystalsLocation = new ResourceLocation("productivebees", "textures/entity/bee/base/" + this.modelType + "/crystals_clear.png");
        BeeBodyLayer.m_117376_(this.model, (ResourceLocation)crystalsLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)color[0], (float)color[1], (float)color[2]);
        if (useGlowLayer) {
            ResourceLocation crystalsOverlayLocation = new ResourceLocation("productivebees", "textures/entity/bee/base/" + this.modelType + "/crystals.png");
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)crystalsOverlayLocation));
            this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        }
    }

    private void renderNectarLayer(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (entity.getColor(0) >= 0) {
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            if (entity instanceof ConfigurableBee) {
                if (((ConfigurableBee)entity).hasBeeTexture()) {
                    return;
                }
                if (((ConfigurableBee)entity).hasParticleColor()) {
                    colors = ((ConfigurableBee)entity).getParticleColor();
                }
            }
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/base/" + this.modelType + "/pollen.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
    }

    private void renderChristmasHat(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (this.isChristmas && entity.getColor(0) >= 0 && !entity.getRenderStatic()) {
            if (entity instanceof ConfigurableBee && ((ConfigurableBee)entity).hasBeeTexture()) {
                return;
            }
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/base/" + this.modelType + "/santa_hat.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderSaddle(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (entity instanceof BumbleBee && ((BumbleBee)entity).m_6254_()) {
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/bumble/saddle.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

