/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class WoodChipRenderer
extends BlockEntityWithoutLevelRenderer {
    private static HashMap<String, TextureAtlasSprite> blockTextureLocations = new HashMap();

    public WoodChipRenderer() {
        super(null, null);
    }

    protected void add(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v) {
        builder.m_85982_(matrixStack.m_85850_().m_85861_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_7120_(0, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    protected void addBox(VertexConsumer builder, PoseStack matrixStack, TextureAtlasSprite sprite, int fromX, int fromY, int toX, int toY) {
        float startX = (float)fromX / 16.0f;
        float startY = (float)fromY / 16.0f;
        float endX = (float)toX / 16.0f;
        float endY = (float)toY / 16.0f;
        this.add(builder, matrixStack, startX, startY, 1.0f, sprite.m_118367_((double)fromX), sprite.m_118393_((double)fromY));
        this.add(builder, matrixStack, endX, startY, 1.0f, sprite.m_118367_((double)toX), sprite.m_118393_((double)fromY));
        this.add(builder, matrixStack, endX, endY, 1.0f, sprite.m_118367_((double)toX), sprite.m_118393_((double)toY));
        this.add(builder, matrixStack, startX, endY, 1.0f, sprite.m_118367_((double)fromX), sprite.m_118393_((double)toY));
        this.add(builder, matrixStack, startX, endY, 1.0f, sprite.m_118367_((double)fromX), sprite.m_118393_((double)toY));
        this.add(builder, matrixStack, endX, endY, 1.0f, sprite.m_118367_((double)toX), sprite.m_118393_((double)toY));
        this.add(builder, matrixStack, endX, startY, 1.0f, sprite.m_118367_((double)toX), sprite.m_118393_((double)fromY));
        this.add(builder, matrixStack, startX, startY, 1.0f, sprite.m_118367_((double)fromX), sprite.m_118393_((double)fromY));
    }

    public void m_108829_(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLightIn, int packedUV) {
        Item item = itemStack.m_41720_();
        if (item instanceof WoodChip) {
            TextureAtlasSprite sprite;
            VertexConsumer builder = renderTypeBuffer.m_6299_(RenderType.m_110463_());
            Block woodBlock = WoodChip.getBlock(itemStack);
            if (woodBlock != null && woodBlock != Blocks.f_50016_ && (sprite = WoodChipRenderer.getBlockSprite(woodBlock)) != null) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                if (!itemStack.m_41794_()) {
                    matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                }
                matrixStack.m_85837_(-0.5, -0.5, -1.0);
                this.addBox(builder, matrixStack, sprite, 5, 1, 9, 12);
                this.addBox(builder, matrixStack, sprite, 6, 0, 8, 1);
                this.addBox(builder, matrixStack, sprite, 4, 2, 5, 8);
                this.addBox(builder, matrixStack, sprite, 3, 3, 4, 5);
                this.addBox(builder, matrixStack, sprite, 9, 3, 10, 10);
                this.addBox(builder, matrixStack, sprite, 10, 4, 11, 7);
                this.addBox(builder, matrixStack, sprite, 5, 12, 8, 13);
                this.addBox(builder, matrixStack, sprite, 6, 13, 7, 14);
                matrixStack.m_85849_();
            }
        }
    }

    protected static TextureAtlasSprite getBlockSprite(@Nonnull Block block) {
        String woodName = block.getRegistryName().toString();
        if (blockTextureLocations.get(woodName) != null) {
            return blockTextureLocations.get(woodName);
        }
        BlockRenderDispatcher manager = Minecraft.m_91087_().m_91289_();
        BakedModel model = manager.m_110910_(block.m_49966_());
        List quads = model.m_6840_(block.m_49966_(), Direction.NORTH, new Random());
        if (quads.isEmpty()) {
            return null;
        }
        TextureAtlasSprite sprite = ((BakedQuad)quads.iterator().next()).m_173410_();
        blockTextureLocations.put(woodName, sprite);
        return blockTextureLocations.get(woodName);
    }
}

