/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.ExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Pair;

public class ExpansionBox
extends Block
implements EntityBlock {
    public static final BooleanProperty HAS_HONEY = BooleanProperty.m_61465_((String)"has_honey");

    public ExpansionBox(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.NORTH)).m_61124_(AdvancedBeehive.EXPANDED, (Comparable)((Object)VerticalHive.NONE))).m_61124_((Property)HAS_HONEY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BeehiveBlock.f_49563_, AdvancedBeehive.EXPANDED, HAS_HONEY});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ExpansionBoxBlockEntity(pos, state);
    }

    public void updateState(Level world, BlockPos pos, BlockState state, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair = ExpansionBox.getAdjacentHive(world, pos);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos hivePos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(world, hivePos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(world, pos, state, directionProperty);
            }
            ((AdvancedBeehive)((BlockState)pair.getRight()).m_60734_()).updateStateWithDirection(world, hivePos, (BlockState)pair.getRight(), directionProperty);
        } else if (!isRemoved) {
            this.updateStateWithDirection(world, pos, state, VerticalHive.NONE);
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        Pair posAndDirection;
        BlockPos hivePos;
        BlockEntity hiveTileEntity;
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        ItemStack heldItem = player.m_21205_();
        if (level instanceof ServerLevel && heldItem.m_41720_().equals(Items.f_42398_) && !((VerticalHive)((Object)state.m_61143_(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) && (pair = ExpansionBox.getAdjacentHive(level, pos)) != null && (hiveTileEntity = level.m_7702_(hivePos = (BlockPos)(posAndDirection = (Pair)pair.getLeft()).getLeft())) instanceof AdvancedBeehiveBlockEntityAbstract) {
            ((AdvancedBeehiveBlockEntityAbstract)hiveTileEntity).m_58748_(player, state, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
        }
        super.m_6256_(state, level, pos, player);
    }

    public void updateStateWithDirection(Level world, BlockPos pos, BlockState state, VerticalHive directionProperty) {
        world.m_46597_(pos, (BlockState)state.m_61124_(AdvancedBeehive.EXPANDED, (Comparable)((Object)directionProperty)));
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentHive(Level world, BlockPos pos) {
        for (Direction direction : BlockStateProperties.f_61372_.m_6908_()) {
            BlockPos newPos;
            BlockState blockStateAtPos;
            Block blockAtPos;
            if (direction == Direction.UP || !((blockAtPos = (blockStateAtPos = world.m_8055_(newPos = pos.m_142300_(direction))).m_60734_()) instanceof AdvancedBeehive) || blockAtPos instanceof DragonEggHive) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.m_5776_()) {
            this.updateState(world, pos, state, false);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean removed = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.m_5776_()) {
            this.updateState(world, pos, state, true);
        }
        return removed;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity;
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        if (!worldIn.f_46443_ && (pair = ExpansionBox.getAdjacentHive(worldIn, pos)) != null && (tileEntity = worldIn.m_7702_((BlockPos)((Pair)pair.getLeft()).getLeft())) instanceof AdvancedBeehiveBlockEntity) {
            this.updateState(worldIn, pos, state, false);
            BlockState blockState = tileEntity.m_58900_();
            worldIn.m_7260_(pos, blockState, blockState, 3);
            ((AdvancedBeehive)blockState.m_60734_()).openGui((ServerPlayer)player, (AdvancedBeehiveBlockEntity)tileEntity);
        }
        return InteractionResult.SUCCESS;
    }
}

