/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.FilterUpgradeItem;
import cy.jdkdigital.productivebees.container.CatcherContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CatcherBlockEntity
extends FluidTankBlockEntity
implements UpgradeableBlockEntity {
    protected int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(11, this){

        @Override
        public boolean isContainerItem(Item item) {
            return item == ModItems.BEE_CAGE.get();
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));

    public CatcherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.CATCHER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CatcherBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % 69 == 0) {
            blockEntity.inventoryHandler.ifPresent(invHandler -> {
                ItemStack invItem;
                if (!invHandler.getStackInSlot(0).m_41619_() && (invItem = invHandler.getStackInSlot(0)).m_41720_() instanceof BeeCage && !BeeCage.isFilled(invItem)) {
                    List bees = level.m_45976_(Bee.class, blockEntity.getBoundingBox());
                    int babeeUpgrades = blockEntity.getUpgradeCount((Item)ModItems.UPGRADE_BREEDING.get());
                    List filterUpgrades = blockEntity.getInstalledUpgrades((Item)ModItems.UPGRADE_FILTER.get());
                    for (Bee bee : bees) {
                        if (babeeUpgrades > 0 && !bee.m_6162_()) continue;
                        boolean isAllowed = false;
                        if (filterUpgrades.size() > 0) {
                            for (ItemStack filter : filterUpgrades) {
                                List<Supplier<BeeIngredient>> allowedBees = FilterUpgradeItem.getAllowedBees(filter);
                                for (Supplier<BeeIngredient> allowedBee : allowedBees) {
                                    String type = BeeIngredientFactory.getIngredientKey(bee);
                                    if (!allowedBee.get().getBeeType().toString().equals(type)) continue;
                                    isAllowed = true;
                                }
                            }
                        } else {
                            isAllowed = true;
                        }
                        if (!isAllowed) continue;
                        ItemStack cageStack = new ItemStack((ItemLike)invItem.m_41720_());
                        BeeCage.captureEntity(bee, cageStack);
                        if (!((InventoryHandlerHelper.ItemHandler)((Object)invHandler)).addOutput(cageStack)) continue;
                        bee.m_146870_();
                        invItem.m_41774_(1);
                    }
                }
            });
        }
        FluidTankBlockEntity.tick(level, pos, state, blockEntity);
    }

    private AABB getBoundingBox() {
        int rangeUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get());
        return new AABB(this.f_58858_).m_82363_((double)rangeUpgrades, 2.0 + (double)rangeUpgrades, (double)rangeUpgrades);
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.CATCHER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new CatcherContainer(windowId, playerInventory, this);
    }
}

