/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.container.GeneIndexerContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.recipe.CombineGeneRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GeneIndexerBlockEntity
extends CapabilityBlockEntity {
    private int tickCounter = 0;
    private boolean needsReindexing = true;
    private boolean isRunning = true;
    private Map<String, Map<Integer, Integer>> index = new HashMap<String, Map<Integer, Integer>>();
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(104, this){

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            return stack.m_41720_().equals(ModItems.GENE.get());
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.tileEntity instanceof GeneIndexerBlockEntity) {
                ((GeneIndexerBlockEntity)this.tileEntity).setDirty();
            }
        }

        @Override
        public int[] getOutputSlots() {
            return IntStream.range(0, this.getSlots()).toArray();
        }

        @Override
        public boolean isInputSlot(int slot) {
            return false;
        }
    });

    public GeneIndexerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.GENE_INDEXER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GeneIndexerBlockEntity blockEntity) {
        if (level != null && !level.f_46443_) {
            if (blockEntity.needsReindexing && !blockEntity.isRunning) {
                GeneIndexerBlockEntity.buildIndex(blockEntity, state);
            }
            if (--blockEntity.tickCounter <= 0) {
                blockEntity.tickCounter = 2;
                if (blockEntity.isRunning && blockEntity.index.size() > 0) {
                    if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                        blockEntity.isRunning = false;
                        return;
                    }
                    Iterator<Map.Entry<String, Map<Integer, Integer>>> indexIterator = blockEntity.index.entrySet().iterator();
                    if (indexIterator.hasNext()) {
                        Map.Entry<String, Map<Integer, Integer>> first = indexIterator.next();
                        if (first.getValue().size() > 1) {
                            Supplier<Stream> sorted = () -> ((Map)first.getValue()).entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue()));
                            Optional firstEntry = sorted.get().findFirst();
                            Optional otherEntry = sorted.get().reduce((entry1, entry2) -> entry2);
                            if (firstEntry.isPresent() && otherEntry.isPresent()) {
                                blockEntity.inventoryHandler.ifPresent(inventory -> {
                                    ItemStack firstStack = inventory.getStackInSlot(((Integer)((Map.Entry)firstEntry.get()).getKey()).intValue());
                                    ItemStack secondStack = inventory.getStackInSlot(((Integer)((Map.Entry)otherEntry.get()).getKey()).intValue());
                                    ItemStack combinedGene = CombineGeneRecipe.mergeGenes(Arrays.asList(firstStack, secondStack));
                                    if (!(firstStack.m_41619_() || secondStack.m_41619_() || combinedGene.m_41619_())) {
                                        if (inventory instanceof InventoryHandlerHelper.ItemHandler && ((InventoryHandlerHelper.ItemHandler)((Object)inventory)).addOutput(combinedGene)) {
                                            firstStack.m_41764_(firstStack.m_41613_() - 1);
                                            secondStack.m_41764_(secondStack.m_41613_() - 1);
                                            inventory.setStackInSlot(((Integer)((Map.Entry)firstEntry.get()).getKey()).intValue(), firstStack);
                                            inventory.setStackInSlot(((Integer)((Map.Entry)otherEntry.get()).getKey()).intValue(), secondStack);
                                            if (Gene.getPurity(combinedGene) == 100) {
                                                indexIterator.remove();
                                            }
                                        }
                                    } else {
                                        indexIterator.remove();
                                    }
                                });
                            }
                        } else if (first.getValue().size() == 1) {
                            Map.Entry<Integer, Integer> innerEntry = first.getValue().entrySet().iterator().next();
                            blockEntity.inventoryHandler.ifPresent(inventory -> {
                                ItemStack stack = inventory.getStackInSlot(((Integer)innerEntry.getKey()).intValue());
                                if (stack.m_41613_() == 1) {
                                    indexIterator.remove();
                                } else if (stack.m_41613_() > 1) {
                                    ItemStack combinedGene = CombineGeneRecipe.mergeGenes(Arrays.asList(stack, stack.m_41777_()));
                                    if (!stack.m_41619_() && !combinedGene.m_41619_() && inventory instanceof InventoryHandlerHelper.ItemHandler && ((InventoryHandlerHelper.ItemHandler)((Object)inventory)).addOutput(combinedGene)) {
                                        stack.m_41764_(stack.m_41613_() - 2);
                                        inventory.setStackInSlot(((Integer)innerEntry.getKey()).intValue(), stack);
                                        if (Gene.getPurity(combinedGene) == 100) {
                                            indexIterator.remove();
                                        }
                                    }
                                } else {
                                    indexIterator.remove();
                                }
                            });
                        } else {
                            indexIterator.remove();
                        }
                    }
                } else {
                    blockEntity.isRunning = false;
                }
            }
        }
    }

    private static void buildIndex(GeneIndexerBlockEntity blockEntity, BlockState state) {
        blockEntity.index.clear();
        blockEntity.inventoryHandler.ifPresent(inventory -> {
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                int purity;
                ItemStack stack = inventory.getStackInSlot(slot);
                if (!stack.m_41720_().equals(ModItems.GENE.get()) || (purity = Gene.getPurity(stack).intValue()) >= 100) continue;
                String key = Gene.getAttributeName(stack);
                if (!blockEntity.index.containsKey(key)) {
                    blockEntity.index.put(key, new HashMap());
                }
                Map<Integer, Integer> internalMap = blockEntity.index.get(key);
                internalMap.put(slot, purity);
            }
        });
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            blockEntity.isRunning = true;
        }
        blockEntity.needsReindexing = false;
    }

    public void setDirty() {
        this.needsReindexing = true;
    }

    @Nonnull
    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.GENE_INDEXER.get()).m_7705_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent(((Block)ModBlocks.GENE_INDEXER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new GeneIndexerContainer(windowId, playerInventory, this);
    }
}

