/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.HoneyGenerator;
import cy.jdkdigital.productivebees.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.container.HoneyGeneratorContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class HoneyGeneratorBlockEntity
extends FluidTankBlockEntity
implements UpgradeableBlockEntity {
    protected int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(2, this){

        @Override
        public boolean isContainerItem(Item item) {
            return item.equals(Items.f_42787_) || ModTags.HONEY_BUCKETS.m_8110_((Object)item) || item.equals(Items.f_42788_);
        }

        @Override
        public boolean isInputSlot(int slot) {
            return slot == 0;
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_((Fluid)ModFluids.HONEY.get());
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (this.fluid.getAmount() > 0) {
                HoneyGeneratorBlockEntity.this.setFilled(true);
            } else {
                HoneyGeneratorBlockEntity.this.setFilled(false);
            }
            HoneyGeneratorBlockEntity.this.m_6596_();
        }
    });
    private List<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(100000));

    private void setFilled(boolean filled) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)HoneyGenerator.FULL, (Comparable)Boolean.valueOf(filled)));
        }
    }

    private void setOn(boolean filled) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)HoneyGenerator.ON, (Comparable)Boolean.valueOf(filled)));
        }
    }

    public HoneyGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntityTypes.HONEY_GENERATOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HoneyGeneratorBlockEntity blockEntity) {
        int tickRate = 10;
        if (++blockEntity.tickCounter % tickRate == 0) {
            double consumeModifier = 1.0 + (double)blockEntity.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY.get());
            double speedModifier = 1.0 + (double)blockEntity.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
            int inputPowerAmount = (int)((double)((Integer)ProductiveBeesConfig.GENERAL.generatorPowerGen.get() * tickRate) * speedModifier);
            int fluidConsumeAmount = (int)((double)((Integer)ProductiveBeesConfig.GENERAL.generatorHoneyUse.get() * tickRate) * speedModifier / consumeModifier);
            blockEntity.fluidInventory.ifPresent(fluidHandler -> blockEntity.energyHandler.ifPresent(handler -> {
                if (fluidHandler.getFluidInTank(0).getAmount() >= fluidConsumeAmount && handler.receiveEnergy(inputPowerAmount, true) > 0) {
                    handler.receiveEnergy(inputPowerAmount, false);
                    fluidHandler.drain(fluidConsumeAmount, IFluidHandler.FluidAction.EXECUTE);
                    blockEntity.setOn(true);
                } else {
                    blockEntity.setOn(false);
                }
            }));
        }
        blockEntity.sendOutPower(tickRate);
        FluidTankBlockEntity.tick(level, pos, state, blockEntity);
    }

    public void sendOutPower(int modifier) {
        if (this.f_58857_ != null) {
            this.energyHandler.ifPresent(energyHandler -> {
                AtomicInteger capacity = new AtomicInteger(energyHandler.getEnergyStored());
                if (capacity.get() > 0) {
                    AtomicBoolean dirty = new AtomicBoolean(false);
                    for (IEnergyStorage handler : this.recipients) {
                        boolean doContinue = true;
                        if (handler.canReceive()) {
                            int received = handler.receiveEnergy(Math.min(capacity.get(), 100 * modifier), false);
                            capacity.addAndGet(-received);
                            energyHandler.extractEnergy(received, false);
                            dirty.set(true);
                            boolean bl = doContinue = capacity.get() > 0;
                        }
                        if (doContinue) continue;
                        break;
                    }
                    if (dirty.get()) {
                        this.m_6596_();
                    }
                }
            });
        }
    }

    @Override
    public void tickFluidTank(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        this.fluidInventory.ifPresent(fluidHandler -> this.inventoryHandler.ifPresent(invHandler -> {
            int fluidSpace = this.fluidInventory.map(h -> h.getTankCapacity(0) - h.getFluidInTank(0).getAmount()).orElse(0);
            if (!invHandler.getStackInSlot(0).m_41619_()) {
                ItemStack invItem = invHandler.getStackInSlot(0);
                ItemStack outputInvItem = invHandler.getStackInSlot(1);
                ItemStack outputItem = ItemStack.f_41583_;
                LazyOptional itemFluidHandler = invItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                boolean isHoneyBottle = invItem.m_41720_().equals(Items.f_42787_);
                boolean isHoneyBlock = invItem.m_41720_().equals(Items.f_42788_);
                boolean isHoneyBucket = ModTags.HONEY_BUCKETS.m_8110_((Object)invItem.m_41720_());
                int addAmount = 0;
                if (isHoneyBottle) {
                    addAmount = 250;
                    outputItem = new ItemStack((ItemLike)Items.f_42590_);
                } else if (isHoneyBlock) {
                    addAmount = 1000;
                } else if (isHoneyBucket) {
                    addAmount = 1000;
                    outputItem = new ItemStack((ItemLike)Items.f_42446_);
                } else if (itemFluidHandler.isPresent()) {
                    addAmount = fluidSpace;
                }
                if (!(outputItem.equals(ItemStack.f_41583_) || outputInvItem.m_41619_() || outputInvItem.m_41720_().equals(outputItem.m_41720_()) && outputInvItem.m_41741_() != outputInvItem.m_41613_())) {
                    return;
                }
                if (itemFluidHandler.isPresent() && itemFluidHandler.map(h -> h.getFluidInTank(0).isEmpty()).orElse(false).booleanValue()) {
                    if (outputInvItem.m_41619_() && !invHandler.insertItem(1, invItem, false).m_41619_()) {
                        invHandler.setStackInSlot(0, ItemStack.f_41583_);
                    }
                    return;
                }
                if (addAmount > 0 && addAmount <= fluidSpace) {
                    int fillAmount = fluidHandler.fill(new FluidStack((Fluid)ModFluids.HONEY.get(), addAmount), IFluidHandler.FluidAction.EXECUTE);
                    if (itemFluidHandler.isPresent()) {
                        FluidUtil.tryEmptyContainer((ItemStack)invItem, (IFluidHandler)fluidHandler, (int)fillAmount, null, (boolean)true);
                    } else {
                        invItem.m_41774_(1);
                        if (!outputItem.equals(ItemStack.f_41583_)) {
                            if (outputInvItem.m_41619_()) {
                                invHandler.setStackInSlot(1, outputItem);
                            } else {
                                outputInvItem.m_41769_(1);
                            }
                        }
                    }
                }
            }
        }));
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        this.refreshConnectedTileEntityCache();
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return new TranslatableComponent(((Block)ModBlocks.HONEY_GENERATOR.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new HoneyGeneratorContainer(windowId, playerInventory, this);
    }

    public void refreshConnectedTileEntityCache() {
        if (this.f_58857_ instanceof ServerLevel) {
            Direction[] directions;
            ArrayList<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
            for (Direction direction : directions = Direction.values()) {
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                if (te == null) continue;
                te.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).ifPresent(recipients::add);
            }
            this.recipients = recipients;
        }
    }
}

