/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.solitary;

import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class BumbleBee
extends SolitaryBee
implements ItemSteerable,
Saddleable {
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(BumbleBee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(BumbleBee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemBasedSteering steering;

    public BumbleBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.steering = new ItemBasedSteering(this.f_19804_, BOOST_TIME, SADDLED);
        this.beehiveInterests = poiType -> poiType == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREAT_ON_A_STICK.get()}), false));
    }

    @Override
    public String getRenderer() {
        return "thicc";
    }

    @Override
    public Tag<Block> getNestingTag() {
        return ModTags.BUMBLE_BEE_NESTS;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (BOOST_TIME.equals(key) && this.f_19853_.f_46443_) {
            this.steering.m_20844_();
        }
        super.m_7350_(key);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(BOOST_TIME, (Object)0);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public boolean m_5807_() {
        Entity entity = this.m_6688_();
        if (!(entity instanceof Player)) {
            return false;
        }
        Player playerEntity = (Player)entity;
        return playerEntity.m_21205_().m_41720_() == ModItems.TREAT_ON_A_STICK.get() || playerEntity.m_21206_().m_41720_() == ModItems.TREAT_ON_A_STICK.get();
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.steering.m_20847_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.steering.m_20852_(compound);
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource soundCategory) {
        this.steering.m_20849_(true);
        if (soundCategory != null) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12236_, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    public float getSizeModifier() {
        return 1.25f;
    }

    public void m_7023_(Vec3 travelVector) {
        this.m_20854_((Mob)this, this.steering, travelVector);
    }

    public boolean m_6746_() {
        return this.steering.m_20845_(this.m_21187_());
    }

    public void m_7760_(Vec3 travelVec) {
        super.m_7023_(travelVec);
    }

    public float m_6748_() {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    @Override
    @Nonnull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean flag = this.m_6898_(player.m_21120_(hand));
        if (!flag && this.m_6254_() && !this.m_20160_() && !player.m_36341_()) {
            if (!this.f_19853_.f_46443_) {
                if (player instanceof ServerPlayer) {
                    ModAdvancements.SADDLE_BEE.trigger((ServerPlayer)player, this);
                }
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_20854_(Mob entity, ItemBasedSteering boostHelper, Vec3 vec3d) {
        Entity rider;
        if (!entity.m_6084_()) {
            return false;
        }
        Entity entity2 = rider = entity.m_20197_().isEmpty() ? null : (Entity)entity.m_20197_().get(0);
        if (entity.m_20160_() && entity.m_5807_() && rider instanceof Player) {
            entity.f_19859_ = rider.m_146908_();
            entity.m_146922_(rider.m_146908_() % 360.0f);
            entity.m_146926_(rider.m_146909_() * 0.5f % 360.0f);
            entity.f_20883_ = entity.m_146908_();
            entity.f_20885_ = entity.m_146908_();
            entity.f_19793_ = 1.0f;
            entity.f_20887_ = entity.m_6113_() * 0.1f;
            if (boostHelper.f_20834_ && boostHelper.f_20835_++ > boostHelper.f_20836_) {
                boostHelper.f_20834_ = false;
            }
            if (entity.m_6109_()) {
                float speed = this.m_6748_();
                if (boostHelper.f_20834_) {
                    speed += speed * 2.15f * Mth.m_14031_((float)((float)boostHelper.f_20835_ / (float)boostHelper.f_20836_ * (float)Math.PI));
                }
                entity.m_7910_(speed);
                this.m_7760_(new Vec3(0.0, !this.f_19853_.m_46859_(this.m_142538_().m_6625_(3)) ? 1.0 : (this.f_19853_.m_46859_(this.m_142538_().m_6625_(1)) ? -1.0 : 0.0), 1.0));
                if (entity instanceof BumbleBee) {
                    this.setNewPosRotationIncrements(0);
                }
            } else {
                entity.m_21043_((LivingEntity)entity, false);
                entity.m_20256_(Vec3.f_82478_);
            }
            return true;
        }
        entity.f_19793_ = 0.5f;
        entity.f_20887_ = 0.02f;
        this.m_7760_(vec3d);
        return false;
    }

    public void setNewPosRotationIncrements(int value) {
        this.f_20903_ = value;
    }
}

