/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.container.ManualSlotItemHandler;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CentrifugeContainer
extends AbstractContainer {
    public final CentrifugeBlockEntity tileEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public CentrifugeContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CentrifugeContainer.getTileEntity(playerInventory, data));
    }

    public CentrifugeContainer(int windowId, Inventory playerInventory, CentrifugeBlockEntity tileEntity) {
        this((MenuType)ModContainerTypes.CENTRIFUGE.get(), windowId, playerInventory, tileEntity);
    }

    public CentrifugeContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, final CentrifugeBlockEntity tileEntity) {
        super(type, windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        this.m_38884_(new ContainerData(){

            public int m_6413_(int i) {
                return i == 0 ? tileEntity.fluidId : tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(fluidHandler -> fluidHandler.getFluidInTank(0).getAmount()).orElse(0);
            }

            public void m_8050_(int i, int value) {
                switch (i) {
                    case 0: {
                        tileEntity.fluidId = value;
                    }
                    case 1: {
                        tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                            FluidStack fluid = fluidHandler.getFluidInTank(0);
                            if (fluid.isEmpty()) {
                                fluidHandler.fill(new FluidStack((Fluid)Registry.f_122822_.m_7942_(tileEntity2.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            } else {
                                fluid.setAmount(value);
                            }
                        });
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return tileEntity.recipeProgress;
            }

            public void m_6422_(int value) {
                tileEntity.recipeProgress = value;
            }
        });
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 1, 13, 35));
            this.addSlotBox((IItemHandler)inv, InventoryHandlerHelper.OUTPUT_SLOTS[0], 67, 17, 3, 18, 3, 18);
        });
        this.tileEntity.getUpgradeHandler().ifPresent(upgradeHandler -> this.addSlotBox((IItemHandler)upgradeHandler, 0, 165, 8, 1, 18, 4, 18));
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static CentrifugeBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof CentrifugeBlockEntity) {
            return (CentrifugeBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof Centrifuge && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getTileEntity() {
        return this.tileEntity;
    }
}

