/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBee;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        Level world;
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.m_41619_() && entity instanceof Bee && (world = entityInteract.getWorld()) instanceof ServerLevel) {
            Player player = entityInteract.getPlayer();
            BlockPos pos = entity.m_142538_();
            Entity newBee = BeeHelper.itemInteract((Bee)entity, itemStack, (ServerLevel)world, entity.serializeNBT(), player);
            if (newBee != null) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                world.m_7967_(newBee);
                entity.m_146870_();
            }
        }
    }

    @SubscribeEvent
    public static void cocoaBreakSpawn(BlockEvent.BreakEvent event) {
        if (event.getState().m_60734_().equals(Blocks.f_50262_) && (Integer)event.getState().m_61143_((Property)CocoaBlock.f_51736_) == 2) {
            Player player = event.getPlayer();
            Level world = player.f_19853_;
            if (world instanceof ServerLevel && player instanceof ServerPlayer && (double)ProductiveBees.rand.nextFloat() < (Double)ProductiveBeesConfig.BEES.sugarbagBeeChance.get()) {
                ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(world);
                BlockPos pos = event.getPos();
                if (bee != null && BeeReloadListener.INSTANCE.getData("productivebees:sugarbag") != null) {
                    bee.setBeeType("productivebees:sugarbag");
                    bee.setAttributes();
                    bee.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                    world.m_5594_(player, pos, SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    world.m_7967_((Entity)bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        EntityType bee;
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.m_20675_().contains("blue_banded_bee")) continue;
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        event.put((EntityType)ModEntities.BLUE_BANDED_BEE.get(), BlueBandedBee.getDefaultAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void fuelValues(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item.equals(ModItems.WAX.get())) {
            event.setBurnTime(100);
        } else if (item.equals(((Block)ModBlocks.WAX_BLOCK.get()).m_5456_())) {
            event.setBurnTime(900);
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            boolean willSpawn = ProductiveBees.rand.nextDouble() < (Double)ProductiveBeesConfig.BEES.fishingBeeChance.get();
            int fishingLuck = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44953_, (ItemStack)player.m_21205_());
            for (int i = 0; i < 1 + fishingLuck; ++i) {
                willSpawn = willSpawn || ProductiveBees.rand.nextDouble() < (Double)ProductiveBeesConfig.BEES.fishingBeeChance.get();
            }
            if (willSpawn) {
                Biome fishingBiome;
                ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(player.f_19853_);
                BlockPos pos = event.getHookEntity().m_142538_();
                if (bee != null && BeeReloadListener.INSTANCE.getData("productivebees:prismarine") != null && (fishingBiome = player.f_19853_.m_46857_(pos)).m_47567_().equals((Object)Biome.BiomeCategory.OCEAN)) {
                    bee.setBeeType("productivebees:prismarine");
                    if (BeeReloadListener.INSTANCE.getData("productivebees:oily") != null && ProductiveBees.rand.nextBoolean()) {
                        bee.setBeeType("productivebees:oily");
                    }
                    bee.setAttributes();
                    bee.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                    player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                    player.f_19853_.m_5594_(player, pos, SoundEvents.f_11741_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    player.f_19853_.m_7967_((Entity)bee);
                    bee.m_6710_((LivingEntity)player);
                    ModAdvancements.FISH_BEE.trigger((ServerPlayer)player, bee);
                }
            }
        }
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IInhabitantStorage.class);
    }
}

