/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class SolitaryNestFeature
extends Feature<ReplaceBlockConfiguration> {
    private final float probability;
    protected boolean placeOntop;

    public SolitaryNestFeature(float probability, Codec<ReplaceBlockConfiguration> configFactory) {
        this(probability, configFactory, false);
    }

    public SolitaryNestFeature(float probability, Codec<ReplaceBlockConfiguration> configFactory, boolean placeOntop) {
        super(configFactory);
        this.probability = probability;
        this.placeOntop = placeOntop;
    }

    public boolean m_142674_(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos blockPos = context.m_159777_();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.m_159778_();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.f_161083_) {
            BlockState state;
            boolean probabilityCheck;
            boolean bl = probabilityCheck = rand.nextFloat() > this.probability;
            if (this.nestShouldNotGenerate(targetBlockState.f_161033_) || probabilityCheck) {
                return false;
            }
            blockPos = blockPos.m_142383_(rand.nextInt(14)).m_142385_(rand.nextInt(14));
            while (blockPos.m_123342_() < 50 || !world.m_46859_(blockPos)) {
                blockPos = blockPos.m_7494_();
            }
            if (!this.placeOntop) {
                blockPos = blockPos.m_7495_();
            }
            if (!targetBlockState.f_161032_.m_7715_(state = this.placeOntop ? world.m_8055_(blockPos.m_7495_()) : world.m_8055_(blockPos), world.m_5822_())) continue;
            return this.placeNest(world, blockPos, targetBlockState.f_161033_);
        }
        return false;
    }

    protected boolean nestShouldNotGenerate(BlockState state) {
        return (Boolean)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("enable_" + state.m_60734_().getRegistryName()).get() == false;
    }

    protected boolean placeNest(WorldGenLevel world, BlockPos pos, BlockState state) {
        Direction direction = state.m_60734_() instanceof WoodNest ? Direction.SOUTH : Direction.UP;
        for (Direction dir : BlockStateProperties.f_61372_.m_6908_()) {
            BlockPos blockPos = pos.m_5484_(dir, 1);
            if (!world.m_46859_(blockPos)) continue;
            direction = dir;
            break;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
        boolean result = world.m_7731_(pos, newState, 1);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SolitaryNestBlockEntity) {
            ProductiveBees.LOGGER.debug("Spawned nest at " + pos + " " + newState);
            Entity newBee = ((SolitaryNest)newState.m_60734_()).getNestingBeeType((Level)world.m_6018_(), world.m_6018_().m_46857_(pos));
            if (newBee instanceof Bee) {
                ((Bee)newBee).m_21153_(((Bee)newBee).m_21233_());
                newBee.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                ((SolitaryNestBlockEntity)blockEntity).m_58744_(newBee, false, world.m_5822_().nextInt(599));
            }
        }
        return result;
    }
}

