/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.AdvancedBeehiveRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AdvancedBeehiveRecipeCategory
implements IRecipeCategory<AdvancedBeehiveRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public AdvancedBeehiveRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_produce_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.ADVANCED_OAK_BEEHIVE.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_ADVANCED_BEEHIVE_UID;
    }

    @Nonnull
    public Class<? extends AdvancedBeehiveRecipe> getRecipeClass() {
        return AdvancedBeehiveRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.advanced_beehive");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull AdvancedBeehiveRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInput(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.ingredient.get()));
        ArrayList outputList = new ArrayList();
        recipe.getRecipeOutputs().forEach((stack, value) -> {
            ArrayList innerList = new ArrayList();
            IntStream.range(value.get(0).m_7047_(), value.get(1).m_7047_() + 1).forEach(i -> {
                ItemStack newStack = stack.m_41777_();
                newStack.m_41764_(i);
                innerList.add(newStack);
            });
            outputList.add(innerList);
        });
        ingredients.setOutputLists(VanillaTypes.ITEM, outputList);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AdvancedBeehiveRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup ingredientStacks = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        ingredientStacks.init(0, true, 7, 27);
        ingredientStacks.set(ingredients);
        int startX = 68;
        int startY = 26;
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            int offset = ingredients.getInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT).size();
            IntStream.range(offset, ingredients.getOutputs(VanillaTypes.ITEM).size() + offset).forEach(i -> {
                if (i > 3 + offset) {
                    return;
                }
                itemStacks.init(i, false, startX + (i - offset) * 18, startY + (int)Math.floor(((float)i - (float)offset) / 3.0f) * 18);
            });
        }
        itemStacks.set(ingredients);
        ArrayList chances = new ArrayList();
        ArrayList amounts = new ArrayList();
        recipe.getRecipeOutputs().forEach((stack, value) -> {
            int chance = value.get(2).m_7047_();
            if (chance < 100) {
                chances.add(new TranslatableComponent("productivebees.centrifuge.tooltip.chance", new Object[]{chance < 1 ? "<1%" : chance + "%"}));
            } else {
                chances.add(new TextComponent(""));
            }
            if (value.get(0) != value.get(1)) {
                amounts.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{value.get(0).m_7047_() + " - " + value.get(1).m_7047_()}));
            } else {
                amounts.add(new TextComponent(""));
            }
        });
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!input) {
                if (!chances.isEmpty() && chances.size() >= slotIndex && !((Component)chances.get(slotIndex - 1)).getString().isEmpty()) {
                    tooltip.add((Component)chances.get(slotIndex - 1));
                }
                if (!amounts.isEmpty() && amounts.size() >= slotIndex && !((Component)amounts.get(slotIndex - 1)).getString().isEmpty()) {
                    tooltip.add((Component)amounts.get(slotIndex - 1));
                }
            }
        });
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AdvancedBeehiveRecipe recipe, List<? extends IFocus<?>> focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 7, 27).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.ingredient.get()))).setSlotName("source");
        if (recipe.getRecipeOutputs().size() > 0) {
            int startX = 69;
            int startY = 27;
            int[] i = new int[]{0};
            recipe.getRecipeOutputs().forEach((stack, value) -> {
                ArrayList innerList = new ArrayList();
                IntStream.range(value.get(0).m_7047_(), value.get(1).m_7047_() + 1).forEach(amount -> {
                    ItemStack newStack = stack.m_41777_();
                    newStack.m_41764_(amount);
                    innerList.add(newStack);
                });
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18, startY + (int)Math.floor((float)i[0] / 3.0f * 18.0f)).addItemStacks(innerList)).addTooltipCallback((recipeSlotView, tooltip) -> {
                    int chance = value.get(2).m_7047_();
                    if (chance < 100) {
                        tooltip.add(new TranslatableComponent("productivebees.centrifuge.tooltip.chance", new Object[]{chance < 1 ? "<1%" : chance + "%"}));
                    } else {
                        tooltip.add(new TextComponent(""));
                    }
                    if (value.get(0) != value.get(1)) {
                        tooltip.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{value.get(0).m_7047_() + " - " + value.get(1).m_7047_()}));
                    } else {
                        tooltip.add(new TextComponent(""));
                    }
                }).setSlotName("output" + i[0]);
                i[0] = i[0] + 1;
            });
        }
    }
}

