/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeFloweringRecipeCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation ID = new ResourceLocation("productivebees", "bee_flowering");
    private final IDrawable icon;
    private final IDrawable background;

    public BeeFloweringRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_flowering_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 70, 82);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Items.f_41940_));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.bee_flowering");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, Collections.singletonList(recipe.getBee()));
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        try {
            List<Block> blockList = new ArrayList();
            if (recipe.blockTag != null) {
                blockList = recipe.blockTag.m_6497_();
            } else if (recipe.block != null) {
                blockList.add(recipe.block);
            } else if (recipe.fluid != null) {
                fluidStacks.add(new FluidStack(recipe.fluid, 1000));
            }
            for (Block block : blockList) {
                ItemStack item = new ItemStack((ItemLike)block.m_5456_());
                if (!item.m_41720_().equals(Items.f_41852_)) {
                    itemStacks.add(item);
                    continue;
                }
                if (!(block instanceof CocoaBlock)) continue;
                itemStacks.add(new ItemStack((ItemLike)Items.f_42533_));
            }
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.warn("Failed to find flowering requirements for " + recipe.getBee());
        }
        ArrayList<ArrayList<ItemStack>> items = new ArrayList<ArrayList<ItemStack>>();
        items.add(itemStacks);
        ingredients.setInputLists(VanillaTypes.ITEM, items);
        ingredients.setInputs(VanillaTypes.FLUID, fluidStacks);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull Recipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        ingredientStacks.init(0, true, 29, 12);
        ingredientStacks.set(0, (List)ingredients.getInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT).get(0));
        if (!ingredients.getInputs(VanillaTypes.ITEM).isEmpty()) {
            IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
            itemStacks.init(1, true, 26, 51);
            itemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        if (!ingredients.getInputs(VanillaTypes.FLUID).isEmpty()) {
            IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
            fluidStacks.init(1, true, 26, 51);
            fluidStacks.set(1, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static List<Recipe> getFlowersRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        HashMap<String, Tag<Block>> flowering = new HashMap<String, Tag<Block>>();
        flowering.put("productivebees:blue_banded_bee", ModTags.RIVER_FLOWERS);
        flowering.put("productivebees:green_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:nomad_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:chocolate_mining_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:ashy_mining_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:reed_bee", ModTags.SWAMP_FLOWERS);
        flowering.put("productivebees:resin_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:sweat_bee", ModTags.SNOW_FLOWERS);
        flowering.put("productivebees:yellow_black_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:lumber_bee", ModTags.LUMBER);
        flowering.put("productivebees:quarry_bee", ModTags.QUARRY);
        flowering.put("productivebees:creeper_bee", ModTags.POWDERY);
        Tag.Named defaultBlockTag = BlockTags.f_13041_;
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            if (entry.getValue().isConfigurable()) {
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getValue().getBeeType().toString());
                if (nbt.m_128441_("flowerTag")) {
                    Tag<Block> flowerTag = ModTags.getBlockTag(new ResourceLocation(nbt.m_128461_("flowerTag")));
                    recipes.add(new Recipe(flowerTag, entry.getValue()));
                    continue;
                }
                if (nbt.m_128441_("flowerBlock")) {
                    Block flowerBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("flowerBlock")));
                    recipes.add(new Recipe(flowerBlock, entry.getValue()));
                    continue;
                }
                if (nbt.m_128441_("flowerFluid")) {
                    Fluid flowerFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("flowerFluid")));
                    recipes.add(new Recipe(flowerFluid, entry.getValue()));
                    continue;
                }
                recipes.add(new Recipe((Tag<Block>)defaultBlockTag, entry.getValue()));
                continue;
            }
            if (flowering.containsKey(entry.getValue().getBeeType().toString())) {
                Tag blockTag = (Tag)flowering.get(entry.getValue().getBeeType().toString());
                recipes.add(new Recipe((Tag<Block>)blockTag, entry.getValue()));
                continue;
            }
            recipes.add(new Recipe((Tag<Block>)defaultBlockTag, entry.getValue()));
        }
        return recipes;
    }

    public static class Recipe {
        private final BeeIngredient bee;
        private final Tag<Block> blockTag;
        private final Block block;
        private final Fluid fluid;

        public Recipe(Tag<Block> blockTag, BeeIngredient bee) {
            this.blockTag = blockTag;
            this.block = null;
            this.fluid = null;
            this.bee = bee;
        }

        public Recipe(Block block, BeeIngredient bee) {
            this.blockTag = null;
            this.block = block;
            this.fluid = null;
            this.bee = bee;
        }

        public Recipe(Fluid fluid, BeeIngredient bee) {
            this.blockTag = null;
            this.block = null;
            this.fluid = fluid;
            this.bee = bee;
        }

        public BeeIngredient getBee() {
            return this.bee;
        }
    }
}

