/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.recipe.BottlerRecipe;
import cy.jdkdigital.productivebees.recipe.TagOutputRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BottlerRecipeCategory
implements IRecipeCategory<BottlerRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("productivebees", "bottler");
    private final IDrawable icon;
    private final IDrawable background;

    public BottlerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bottler_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.BOTTLER.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BottlerRecipe> getRecipeClass() {
        return BottlerRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.bottler");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BottlerRecipe recipe, IIngredients ingredients) {
        List<Fluid> fluids = TagOutputRecipe.getAllFluidsFromName((String)recipe.fluidInput.getFirst());
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (Fluid fluid : fluids) {
            fluidStacks.add(new FluidStack(fluid, ((Integer)recipe.fluidInput.getSecond()).intValue()));
        }
        ingredients.setInputs(VanillaTypes.FLUID, fluidStacks);
        ingredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.itemInput}));
        ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.result.m_43908_()));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, @Nonnull BottlerRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = iRecipeLayout.getFluidStacks();
        fluids.init(0, true, 9, 27);
        fluids.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(1, true, 42, 26);
        itemStacks.init(2, false, 98, 26);
        itemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        fluids.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            int amount = (Integer)recipe.fluidInput.getSecond();
            tooltip.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{amount + "mB"}));
        });
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BottlerRecipe recipe, List<? extends IFocus<?>> focuses) {
        List<Fluid> fluids = TagOutputRecipe.getAllFluidsFromName((String)recipe.fluidInput.getFirst());
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (Fluid fluid : fluids) {
            fluidStacks.add(new FluidStack(fluid, ((Integer)recipe.fluidInput.getSecond()).intValue()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 28).addIngredients(VanillaTypes.FLUID, fluidStacks)).setSlotName("inputFluid");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 43, 27).addItemStacks(Arrays.stream(recipe.itemInput.m_43908_()).toList())).setSlotName("inputItem");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 27).addItemStacks(Arrays.stream(recipe.result.m_43908_()).toList())).setSlotName("result");
    }
}

