/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.top;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ITheOneProbe;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TopPlugin
implements Function<ITheOneProbe, Void> {
    MutableComponent formattedName = new TextComponent("Productive Bees").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            ResourceLocation registryName;
            BlockEntity tileEntity = world.m_7702_(data.getPos());
            if (tileEntity instanceof SolitaryNestBlockEntity) {
                SolitaryNestBlockEntity nest = (SolitaryNestBlockEntity)tileEntity;
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).text((Component)this.formattedName);
                List<AdvancedBeehiveBlockEntityAbstract.Inhabitant> bees = nest.getBeeList();
                if (!bees.isEmpty()) {
                    probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.bee", new Object[]{bees.get((int)0).localizedName}));
                    if (bees.get((int)0).minOccupationTicks - bees.get((int)0).ticksInHive > 0) {
                        probeInfo.progress(Math.max(0, bees.get((int)0).minOccupationTicks - bees.get((int)0).ticksInHive), bees.get((int)0).minOccupationTicks);
                    }
                } else if (nest.getNestTickCooldown() > 0) {
                    probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown"));
                    probeInfo.progress(nest.getNestTickCooldown() / 20, (Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get() / 20);
                } else {
                    probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown_inactive"));
                    if (nest.canRepopulate()) {
                        probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_true"));
                    } else {
                        probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_false"));
                    }
                }
                return true;
            }
            if (tileEntity instanceof CentrifugeBlockEntity) {
                CentrifugeBlockEntity centrifugeTileEntity = (CentrifugeBlockEntity)tileEntity;
                if (centrifugeTileEntity.recipeProgress > 0) {
                    probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).progress((int)Math.floor(centrifugeTileEntity.recipeProgress), centrifugeTileEntity.getProcessingTime()).text((Component)this.formattedName);
                    return true;
                }
            }
            if ((registryName = blockState.m_60734_().getRegistryName()) != null && registryName.m_135827_().equals("productivebees")) {
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).text((Component)this.formattedName);
                return true;
            }
            return false;
        });
        return null;
    }
}

