/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TagOutputRecipe {
    public final Map<Ingredient, IntArrayTag> itemOutput;
    public final Map<ItemStack, IntArrayTag> calculatedItemOutput = new LinkedHashMap<ItemStack, IntArrayTag>();
    public static Map<String, Integer> modPreference = new HashMap<String, Integer>();

    public TagOutputRecipe(Ingredient itemOutput) {
        this.itemOutput = new LinkedHashMap<Ingredient, IntArrayTag>();
        this.itemOutput.put(itemOutput, new IntArrayTag(new int[]{1, 1, 100}));
    }

    public TagOutputRecipe(Map<Ingredient, IntArrayTag> itemOutput) {
        this.itemOutput = itemOutput;
    }

    public Map<ItemStack, IntArrayTag> getRecipeOutputs() {
        if (this.calculatedItemOutput.isEmpty() && !this.itemOutput.isEmpty()) {
            this.itemOutput.forEach((ingredient, intNBT) -> {
                ItemStack preferredItem = TagOutputRecipe.getPreferredItemByMod(ingredient);
                if (preferredItem != null && !preferredItem.m_41720_().equals(Items.f_42127_)) {
                    this.calculatedItemOutput.put(preferredItem, (IntArrayTag)intNBT);
                }
            });
        }
        return new LinkedHashMap<ItemStack, IntArrayTag>(this.calculatedItemOutput);
    }

    private static ItemStack getPreferredItemByMod(Ingredient ingredient) {
        List<ItemStack> stacks = Arrays.asList(ingredient.m_43908_());
        return TagOutputRecipe.getPreferredItemByMod(stacks);
    }

    private static ItemStack getPreferredItemByMod(List<ItemStack> list) {
        ItemStack preferredItem = null;
        int currBest = TagOutputRecipe.getModPreference().size();
        for (ItemStack item : list) {
            ResourceLocation rl = item.m_41720_().getRegistryName();
            if (rl == null) continue;
            String modId = rl.m_135827_();
            int priority = 100;
            if (TagOutputRecipe.getModPreference().containsKey(modId)) {
                priority = TagOutputRecipe.getModPreference().get(modId);
            }
            if (preferredItem != null && (priority < 0 || priority > currBest)) continue;
            preferredItem = item.m_41777_();
            currBest = priority;
        }
        return preferredItem;
    }

    public static Fluid getPreferredFluidByMod(String fluidName) {
        Fluid preferredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (preferredFluid == null || preferredFluid.equals(Fluids.f_76191_)) {
            try {
                Tag fluidTag = SerializationTags.m_13199_().m_144452_(Registry.f_122899_).m_13404_(new ResourceLocation(fluidName));
                if (fluidTag != null && fluidTag.m_6497_().size() > 0) {
                    int currBest = 100;
                    for (Fluid fluid : fluidTag.m_6497_()) {
                        ResourceLocation rl;
                        if (!fluid.m_7444_(fluid.m_76145_())) {
                            fluid = ((FlowingFluid)fluid).m_5613_();
                        }
                        if (!fluid.m_7444_(fluid.m_76145_()) || (rl = fluid.getRegistryName()) == null) continue;
                        String modId = rl.m_135827_();
                        int priority = currBest;
                        if (TagOutputRecipe.getModPreference().containsKey(modId)) {
                            priority = TagOutputRecipe.getModPreference().get(modId);
                        }
                        if (preferredFluid != null && (priority < 0 || priority > currBest)) continue;
                        preferredFluid = fluid;
                        currBest = priority;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return preferredFluid;
    }

    public static List<Fluid> getAllFluidsFromName(String fluidName) {
        List<Fluid> fluids = Collections.singletonList((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName)));
        if (fluids.get(0).equals(Fluids.f_76191_)) {
            try {
                Tag fluidTag = SerializationTags.m_13199_().m_144452_(Registry.f_122899_).m_13404_(new ResourceLocation(fluidName));
                if (fluidTag != null && fluidTag.m_6497_().size() > 0) {
                    return fluidTag.m_6497_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fluids;
    }

    private static Map<String, Integer> getModPreference() {
        if (modPreference.size() > 0) {
            return modPreference;
        }
        int priority = 0;
        for (String modId : (List)ProductiveBeesConfig.GENERAL.preferredTagSource.get()) {
            if (!ModList.get().isLoaded(modId)) continue;
            modPreference.put(modId, ++priority);
        }
        return modPreference;
    }
}

