/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.ModItems;
import vazkii.morphtool.MorphRecipeSerializer;
import vazkii.morphtool.MorphingHandler;

public class AttachementRecipe
extends CustomRecipe {
    public AttachementRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer var1, Level var2) {
        boolean foundTool = false;
        boolean foundTarget = false;
        for (int i = 0; i < var1.m_6643_(); ++i) {
            ItemStack stack = var1.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.m_41720_() == ModItems.tool) {
                if (foundTool) {
                    return false;
                }
                foundTool = true;
                continue;
            }
            return false;
        }
        return foundTool && foundTarget;
    }

    public ItemStack assemble(CraftingContainer var1) {
        String mod;
        CompoundTag morphData;
        ItemStack tool = ItemStack.f_41583_;
        ItemStack target = ItemStack.f_41583_;
        for (int i = 0; i < var1.m_6643_(); ++i) {
            ItemStack stack = var1.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == ModItems.tool) {
                tool = stack;
                continue;
            }
            target = stack;
        }
        ItemStack copy = tool.m_41777_();
        CompoundTag cmp = copy.m_41783_();
        if (cmp == null) {
            cmp = new CompoundTag();
            copy.m_41751_(cmp);
        }
        if (!cmp.m_128441_("morphtool:data")) {
            cmp.m_128365_("morphtool:data", (Tag)new CompoundTag());
        }
        if ((morphData = cmp.m_128469_("morphtool:data")).m_128441_(mod = MorphingHandler.getModFromStack(target))) {
            return ItemStack.f_41583_;
        }
        CompoundTag modCmp = new CompoundTag();
        target.m_41739_(modCmp);
        morphData.m_128365_(mod, (Tag)modCmp);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack.m_41619_() || MorphingHandler.isMorphTool(stack)) {
            return false;
        }
        String mod = MorphingHandler.getModFromStack(stack);
        if (mod.equals("minecraft")) {
            return false;
        }
        if (((Boolean)ConfigHandler.allItems.get()).booleanValue()) {
            return true;
        }
        if (((List)ConfigHandler.blacklistedMods.get()).contains(mod)) {
            return false;
        }
        ResourceLocation registryNameRL = stack.m_41720_().getRegistryName();
        String registryName = registryNameRL.toString();
        if (((List)ConfigHandler.whitelistedItems.get()).contains(registryName) || ((List)ConfigHandler.whitelistedItems.get()).contains(registryName + ":" + stack.m_41773_())) {
            return true;
        }
        String itemName = registryNameRL.m_135815_().toLowerCase();
        for (String s : (List)ConfigHandler.whitelistedNames.get()) {
            if (!itemName.contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return MorphRecipeSerializer.ATTACHMENT;
    }
}

