/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.OpenPlayerInvMessage;
import com.darkere.crashutils.Screens.PlayerInvContainer;
import com.mojang.authlib.GameProfile;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PlayerInventoryRequestMessage {
    String playerName;

    public PlayerInventoryRequestMessage(String s) {
        this.playerName = s;
    }

    public static void encode(PlayerInventoryRequestMessage data, FriendlyByteBuf buf) {
        buf.writeInt(data.playerName.length());
        buf.m_130070_(data.playerName);
    }

    public static PlayerInventoryRequestMessage decode(FriendlyByteBuf buf) {
        return new PlayerInventoryRequestMessage(buf.m_130136_(buf.readInt()));
    }

    public static boolean handle(PlayerInventoryRequestMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            MinecraftServer server = player.m_20194_();
            if (!player.m_20310_(2)) {
                return;
            }
            ServerPlayer otherPlayer = ((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_6846_().m_11255_(data.playerName);
            if (otherPlayer == null) {
                Optional profile = server.m_129927_().m_10996_(data.playerName);
                if (profile.isEmpty()) {
                    player.m_6352_((Component)new TextComponent("Cannot find Player"), new UUID(0L, 0L));
                    return;
                }
                otherPlayer = new FakePlayer(server.m_129880_(Level.f_46428_), (GameProfile)profile.get());
                CompoundTag nbt = server.f_129745_.m_78435_((Player)otherPlayer);
                if (nbt == null) {
                    player.m_6352_((Component)new TextComponent("Cannot load playerData"), new UUID(0L, 0L));
                    return;
                }
                otherPlayer.m_20258_(nbt);
            }
            LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
            if (CrashUtils.curiosLoaded) {
                ((ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)otherPlayer).orElse(null)).getCurios().forEach((s, handler) -> curios.put((String)s, handler.getSlots()));
            }
            player.m_9230_();
            player.m_9217_();
            int id = player.f_8940_;
            Network.sendToPlayer(player, new OpenPlayerInvMessage(id, data.playerName, curios));
            player.f_36096_ = new PlayerInvContainer((Player)player, (Player)otherPlayer, id, null, null, 0);
            player.m_143399_(player.f_36096_);
        });
        return true;
    }
}

