/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class RemoveEntityMessage {
    ResourceKey<Level> worldRegistryKey;
    UUID id;
    boolean tile;
    boolean force;

    public RemoveEntityMessage(ResourceKey<Level> worldRegistryKey, UUID id, boolean tile, boolean force) {
        this.worldRegistryKey = worldRegistryKey;
        this.id = id;
        this.tile = tile;
        this.force = force;
    }

    public static void encode(RemoveEntityMessage data, FriendlyByteBuf buf) {
        NetworkTools.writeWorldKey(data.worldRegistryKey, buf);
        buf.m_130077_(data.id);
        buf.writeBoolean(data.tile);
        buf.writeBoolean(data.force);
    }

    public static RemoveEntityMessage decode(FriendlyByteBuf buf) {
        return new RemoveEntityMessage(NetworkTools.readWorldKey(buf), buf.m_130259_(), buf.readBoolean(), buf.readBoolean());
    }

    public static boolean handle(RemoveEntityMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !player.m_20310_(2)) {
                return;
            }
            if (data.tile) {
                WorldUtils.removeTileEntity((Level)player.m_20194_().m_129880_(data.worldRegistryKey), data.id, data.force);
            } else {
                WorldUtils.removeEntity((Level)player.m_20194_().m_129880_(data.worldRegistryKey), data.id, data.force);
            }
        });
        return true;
    }
}

