/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.DataStructures.EntityData;
import com.darkere.crashutils.DataStructures.LoadedChunkData;
import com.darkere.crashutils.DataStructures.PlayerData;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.OpenEnderChestMessage;
import com.darkere.crashutils.Network.PlayerInventoryRequestMessage;
import com.darkere.crashutils.Network.TeleportToPlayerMessage;
import com.darkere.crashutils.Screens.CUList;
import com.darkere.crashutils.Screens.CUOption;
import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.GuiTools;
import com.darkere.crashutils.WorldUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class DataListLoader {
    int XTopLeft;
    int YTopLeft;
    int XAcross;
    int YAcross;
    CUList currentList;
    Comparator<CUOption> comp = Comparator.comparingInt(x -> x.number);
    Consumer<List<CUOption>> numberComparer = sort -> sort.sort(this.comp.reversed());
    Consumer<List<CUOption>> stringSorter = sort -> sort.sort(Comparator.comparing(CUOption::getString));
    Comparator<CUOption> compX = Comparator.comparingInt(x -> x.blockPos.m_123341_());
    Consumer<List<CUOption>> positionSorter = option -> option.sort(this.compX.thenComparingInt(x -> x.getBlockPos().m_123343_()));
    CUScreen parent;
    ResourceKey<Level> world;
    Consumer<CUOption> tpAction = option -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        WorldUtils.teleportPlayer((Player)player, player.m_20193_(), player.m_20193_(), option.blockPos);
    };
    List<Runnable> history = new ArrayList<Runnable>();

    public DataListLoader(int XTopLeft, int YTopLeft, int XAcross, int YAcross, CUScreen screen, ResourceKey<Level> world) {
        this.XTopLeft = XTopLeft;
        this.YTopLeft = YTopLeft;
        this.XAcross = XAcross;
        this.YAcross = YAcross;
        this.parent = screen;
        this.world = world;
        this.setCurrentList(new ArrayList<CUOption>(), null, null, false);
    }

    public void goBack() {
        if (this.history.size() > 0) {
            this.history.remove(this.history.size() - 1);
        }
        if (this.history.size() > 0) {
            this.history.get(this.history.size() - 1).run();
        } else {
            this.loadOrderedEntityList(true);
        }
        System.out.println("GONE BACK");
    }

    private void addToHistory(Runnable runnable) {
        this.history.add(runnable);
        System.out.println("Added");
    }

    private void setCurrentList(List<CUOption> list, Consumer<List<CUOption>> sorter, Consumer<CUOption> action, boolean isUpdate) {
        if (isUpdate) {
            this.currentList.updateOptions(list, sorter, action);
        } else {
            this.currentList = new CUList(list, this.XTopLeft, this.YTopLeft, this.XAcross, this.YAcross, this.parent, sorter, action);
        }
    }

    private void setReloadListener(DataRequestType type, Runnable listener) {
        DataHolder.setRequestType(type);
        DataHolder.requestUpdates(0, this.world, true);
        DataHolder.setListener(listener);
    }

    public void loadOrderedEntityList(boolean isUpdate) {
        EntityData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.ENTITYDATA, () -> this.loadOrderedEntityList(true));
            this.addToHistory(() -> this.loadOrderedEntityList(true));
        }
        if ((data = DataHolder.getLatestEntityData()) == null) {
            return;
        }
        List<CUOption> list = data.getAsCUOptions();
        list.forEach(option -> {
            option.addButton("Remove", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Remove all entities of this type", x, y, this.parent), x -> WorldUtils.removeEntityType((Level)Minecraft.m_91087_().f_91073_, option.rl, false));
            option.addButton("Wipe", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Forcefully remove all entities of this type", x, y, this.parent), x -> WorldUtils.removeEntityType((Level)Minecraft.m_91087_().f_91073_, option.rl, true));
        });
        Consumer<CUOption> action = option -> this.loadChunkListForEntity(option.getRl(), false);
        this.setCurrentList(list, this.numberComparer, action, isUpdate);
    }

    public void loadChunkListForEntity(ResourceLocation name, boolean isUpdate) {
        EntityData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.ENTITYDATA, () -> this.loadChunkListForEntity(name, true));
            this.addToHistory(() -> this.loadChunkListForEntity(name, true));
        }
        if ((data = DataHolder.getLatestEntityData()) == null) {
            return;
        }
        List<CUOption> list = data.getAsCUOptionsOfType(name);
        list.forEach(option -> {
            option.addButton("Remove", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Remove all " + option.rl + " in this chunk", x, y, this.parent), x -> WorldUtils.removeEntitiesInChunk((Level)Minecraft.m_91087_().f_91073_, option.chunkPos, option.rl, false));
            option.addButton("Wipe", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Forcefully remove all " + option.rl + " in this chunk", x, y, this.parent), x -> WorldUtils.removeEntitiesInChunk((Level)Minecraft.m_91087_().f_91073_, option.chunkPos, option.rl, true));
        });
        Consumer<CUOption> action = option -> this.loadEntitiesInChunkAsList(option.chunkPos, name, false);
        this.setCurrentList(list, this.numberComparer, action, isUpdate);
    }

    public void loadEntitiesInChunkAsList(ChunkPos chunkPos, ResourceLocation name, boolean isUpdate) {
        EntityData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.ENTITYDATA, () -> this.loadEntitiesInChunkAsList(chunkPos, name, true));
            this.addToHistory(() -> this.loadEntitiesInChunkAsList(chunkPos, name, true));
        }
        if ((data = DataHolder.getLatestEntityData()) == null) {
            return;
        }
        List<CUOption> list = data.getInChunkAsCUOptions(chunkPos, name);
        list.forEach(option -> {
            option.addButton("Teleport", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Teleport to Entity", x, y, this.parent), x -> this.tpAction.accept((CUOption)option));
            option.addButton("Remove", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Remove this Entity", x, y, this.parent), x -> WorldUtils.removeEntity((Level)Minecraft.m_91087_().f_91073_, option.id, false));
            option.addButton("Wipe", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Forcefully remove this Entity", x, y, this.parent), x -> WorldUtils.removeEntity((Level)Minecraft.m_91087_().f_91073_, option.id, true));
        });
        this.setCurrentList(list, this.positionSorter, null, isUpdate);
    }

    public void loadOrderedTileEntityList(boolean isUpdate) {
        TileEntityData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.TILEENTITYDATA, () -> this.loadOrderedTileEntityList(true));
            this.addToHistory(() -> this.loadOrderedTileEntityList(true));
        }
        if ((data = DataHolder.getLatestTileEntityData()) == null) {
            return;
        }
        List<CUOption> list = data.getAsCUOptions();
        list.forEach(option -> {
            option.addButton("Remove TE", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Remove all loaded TileEntities of this type", x, y, this.parent), b -> WorldUtils.removeTileEntityType((Level)Minecraft.m_91087_().f_91073_, option.rl, false));
            option.addButton("Remove Block", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Delete Blocks with this loaded TileEntity", x, y, this.parent), b -> WorldUtils.removeTileEntityType((Level)Minecraft.m_91087_().f_91073_, option.rl, true));
        });
        Consumer<CUOption> action = option -> this.loadChunkListForTileEntity(option.rl, false);
        this.setCurrentList(list, this.numberComparer, action, isUpdate);
    }

    public void loadChunkListForTileEntity(ResourceLocation name, boolean isUpdate) {
        TileEntityData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.TILEENTITYDATA, () -> this.loadChunkListForTileEntity(name, true));
            this.addToHistory(() -> this.loadChunkListForTileEntity(name, true));
        }
        if ((data = DataHolder.getLatestTileEntityData()) == null) {
            return;
        }
        List<CUOption> list = data.getAsCUOptionsOfType(name);
        list.forEach(option -> {
            option.addButton("Teleport", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Teleport to the center of the chunk", x, y, this.parent), x -> WorldUtils.teleportPlayer((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20193_(), Minecraft.m_91087_().f_91074_.m_20193_(), WorldUtils.getChunkCenter(option.chunkPos)));
            option.addButton("Remove", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Remove all " + option.rl + " in this chunk", x, y, this.parent), x -> WorldUtils.removeTileEntitiesInChunk((Level)Minecraft.m_91087_().f_91073_, option.chunkPos, option.rl, false));
            option.addButton("Remove Block", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Delete all " + option.rl + " in this chunk", x, y, this.parent), x -> WorldUtils.removeTileEntitiesInChunk((Level)Minecraft.m_91087_().f_91073_, option.chunkPos, option.rl, true));
        });
        Consumer<CUOption> action = option -> this.loadTileEntitiesInChunkList(option.chunkPos, name, false);
        this.setCurrentList(list, this.numberComparer, action, isUpdate);
    }

    public void loadTileEntitiesInChunkList(ChunkPos chunkPos, ResourceLocation name, boolean isUpdate) {
        TileEntityData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.TILEENTITYDATA, () -> this.loadTileEntitiesInChunkList(chunkPos, name, true));
            this.addToHistory(() -> this.loadTileEntitiesInChunkList(chunkPos, name, true));
        }
        if ((data = DataHolder.getLatestTileEntityData()) == null) {
            return;
        }
        List<CUOption> list = data.getInChunkAsCUOptions(chunkPos, name);
        list.forEach(option -> {
            option.addButton("Teleport", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Teleport to Entity", x, y, this.parent), x -> this.tpAction.accept((CUOption)option));
            option.addButton("Remove", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Remove TileEntity", x, y, this.parent), x -> WorldUtils.removeTileEntity((Level)Minecraft.m_91087_().f_91073_, option.id, false));
            option.addButton("Remove Block", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Delete Block of this TileEntity", x, y, this.parent), x -> WorldUtils.removeTileEntity((Level)Minecraft.m_91087_().f_91073_, option.id, true));
        });
        this.setCurrentList(list, this.positionSorter, this.tpAction, isUpdate);
    }

    public void loadStateList(boolean isUpdate) {
        LoadedChunkData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.LOADEDCHUNKDATA, () -> this.loadStateList(true));
            this.addToHistory(() -> this.loadStateList(true));
        }
        if ((data = DataHolder.getLatestChunkData()) == null) {
            return;
        }
        List<CUOption> list = data.getStatesAsDropdownOptions("");
        Consumer<CUOption> action = option -> this.loadFilteredStateList(option.getString(), false);
        this.setCurrentList(list, null, action, isUpdate);
    }

    private void loadFilteredStateList(String filter, boolean isUpdate) {
        LoadedChunkData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.LOADEDCHUNKDATA, () -> this.loadFilteredStateList(filter, true));
            this.addToHistory(() -> this.loadFilteredStateList(filter, true));
        }
        if ((data = DataHolder.getLatestChunkData()) == null) {
            return;
        }
        List<CUOption> list = data.getStatesAsDropdownOptions(filter);
        list.forEach(option -> option.addButton("Teleport", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Teleport to the center of the chunk", x, y, this.parent), x -> WorldUtils.teleportPlayer((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20193_(), Minecraft.m_91087_().f_91074_.m_20193_(), WorldUtils.getChunkCenter(option.chunkPos))));
        this.setCurrentList(list, null, null, isUpdate);
    }

    public void loadTicketList(boolean isUpdate) {
        LoadedChunkData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.LOADEDCHUNKDATA, () -> this.loadTicketList(true));
            this.addToHistory(() -> this.loadTicketList(true));
        }
        if ((data = DataHolder.getLatestChunkData()) == null) {
            return;
        }
        List<CUOption> list = data.getTicketsAsDropdownOptions("");
        Consumer<CUOption> action = option -> this.loadFilteredTicketList(option.getString(), false);
        this.setCurrentList(list, null, action, isUpdate);
    }

    private void loadFilteredTicketList(String filter, boolean isUpdate) {
        LoadedChunkData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.LOADEDCHUNKDATA, () -> this.loadFilteredTicketList(filter, true));
            this.addToHistory(() -> this.loadFilteredTicketList(filter, true));
        }
        if ((data = DataHolder.getLatestChunkData()) == null) {
            return;
        }
        List<CUOption> list = data.getTicketsAsDropdownOptions(filter);
        list.forEach(option -> option.addButton("Teleport", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Teleport to the center of the chunk", x, y, this.parent), x -> WorldUtils.teleportPlayer((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20193_(), Minecraft.m_91087_().f_91074_.m_20193_(), WorldUtils.getChunkCenter(option.chunkPos))));
        this.setCurrentList(list, null, null, isUpdate);
    }

    public void loadPlayerList(boolean isUpdate) {
        PlayerData data;
        if (!isUpdate) {
            this.setReloadListener(DataRequestType.PLAYERDATA, () -> this.loadPlayerList(true));
            this.addToHistory(() -> this.loadPlayerList(true));
        }
        if ((data = DataHolder.getLatestPlayerData()) == null) {
            return;
        }
        List<CUOption> list = data.getCUPlayers(Minecraft.m_91087_().f_91074_.m_7755_().getString());
        list.forEach(option -> {
            option.addButton("Inventory", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Open the Players Inventory", x, y, this.parent), x -> {
                if (option.getString() != null) {
                    Network.sendToServer(new PlayerInventoryRequestMessage(option.string));
                }
            });
            option.addButton("Teleport", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Teleport to the player", x, y, this.parent), x -> {
                if (option.getString() != null) {
                    Network.sendToServer(new TeleportToPlayerMessage(option.getString()));
                }
            });
            option.addButton("EnderChest", (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, "Open Enderchest", x, y, this.parent), x -> {
                if (option.getString() != null) {
                    Network.sendToServer(new OpenEnderChestMessage(option.string));
                }
            });
        });
        this.setCurrentList(list, this.stringSorter, null, isUpdate);
    }
}

