/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Screens.CUContentPane;
import com.darkere.crashutils.Screens.CUDropDown;
import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.FillMany;
import com.darkere.crashutils.Screens.Types.DropDownType;
import com.darkere.crashutils.Screens.Types.GridRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class MapGUI
extends CUContentPane {
    int XOffset = -50;
    int YOffset = -50;
    Map<String, Integer> colormap = new HashMap<String, Integer>();
    Random random = new Random();
    float zoom = 1.0f;
    GridRenderType type = GridRenderType.LOCATIONTYPE;
    String renderFilter = null;
    CUDropDown RENDERTYPES;
    CUDropDown TICKETS;
    CUDropDown ENTITIES;
    CUDropDown TILEENTITIES;
    int hoveringX;
    int hoveringY = 0;
    long blinkTime = 0L;
    private String entityFilter;
    BlockPos initial;

    MapGUI(CUScreen screen, ResourceKey<Level> dim, BlockPos initial) {
        super(dim, screen);
        this.initial = initial;
        this.goTo(initial);
        DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
        DataHolder.requestUpdates(0, dim, true);
        this.colormap.put(null, -9934744);
        this.colormap.put("PARTIALLYGENERATED", -10027111);
        this.colormap.put("BORDER", -103);
        this.colormap.put("PRIMED", -10092289);
        this.colormap.put("ENTITY_TICKING", -65536);
        this.colormap.put("TICKING", -65281);
        this.colormap.put("INACCESSIBLE", -9934744);
        this.colormap.put("FULL", -9934744);
        this.colormap.put("no_ticket", -6250336);
        this.RENDERTYPES = new CUDropDown(DropDownType.RENDERTYPES, screen, Arrays.stream(GridRenderType.values()).map(x -> x.type).collect(Collectors.toList()), GridRenderType.LOCATIONTYPE.type, -192, -105, 75);
        this.TICKETS = new CUDropDown(DropDownType.TICKETS, screen, DataHolder.getLatestChunkData() == null ? new ArrayList<String>() : new ArrayList<String>(DataHolder.getLatestChunkData().getChunksByTicketName().keySet()), "all", -106, -105, 0);
        this.ENTITIES = new CUDropDown(DropDownType.ENTITIES, screen, DataHolder.getLatestEntityData() == null ? new ArrayList<String>() : DataHolder.getLatestEntityData().getMap().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList()), "all", -106, -105, 0);
        this.TILEENTITIES = new CUDropDown(DropDownType.TILEENTITIES, screen, DataHolder.getLatestTileEntityData() == null ? new ArrayList<String>() : DataHolder.getLatestTileEntityData().getMap().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList()), "all", -106, -105, 0);
        screen.topDropDowns.add(this.RENDERTYPES);
        screen.topDropDowns.add(this.TICKETS);
        screen.topDropDowns.add(this.ENTITIES);
        screen.topDropDowns.add(this.TILEENTITIES);
        this.RENDERTYPES.setEnabled(true);
        DataHolder.setListener(() -> {
            this.TICKETS.updateOptions(DataHolder.getLatestChunkData() == null ? new ArrayList<String>() : new ArrayList<String>(DataHolder.getLatestChunkData().getChunksByTicketName().keySet()));
            this.ENTITIES.updateOptions(DataHolder.getLatestEntityData() == null ? new ArrayList<String>() : DataHolder.getLatestEntityData().getMap().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            this.TILEENTITIES.updateOptions(DataHolder.getLatestTileEntityData() == null ? new ArrayList<String>() : DataHolder.getLatestTileEntityData().getMap().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            DataHolder.resetFilters();
        });
    }

    @Override
    public void render(PoseStack stack, int centerX, int centerY, int mx, int my, float partialTicks) {
        super.render(stack, centerX, centerY, mx, my, partialTicks);
        ArrayList<FillMany.ColoredRectangle> list = new ArrayList<FillMany.ColoredRectangle>();
        for (int i = 0; i < this.XAcross; ++i) {
            for (int j = 0; j < this.YAcross; ++j) {
                int x = this.getColorForPixel(i, j);
                if (x == 0) continue;
                list.add(new FillMany.ColoredRectangle(i + this.XTopLeft, j + this.YTopLeft, i + 1 + this.XTopLeft, j + 1 + this.YTopLeft, x));
            }
        }
        FillMany.fillMany(stack.m_85850_().m_85861_(), list);
    }

    public void goTo(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        this.XOffset = -170 + chunkPos.f_45578_;
        this.YOffset = -90 + chunkPos.f_45579_;
    }

    public void setRenderType(GridRenderType type) {
        this.type = type;
    }

    public void setRenderFilter(String renderFilter) {
        this.renderFilter = renderFilter;
    }

    private int getColorForPixel(int i, int j) {
        int newi = Math.round((float)i / this.zoom);
        int newj = Math.round((float)j / this.zoom);
        int posX = newi + this.XOffset;
        int posY = newj + this.YOffset;
        if (posX == this.hoveringX && posY == this.hoveringY && System.currentTimeMillis() - this.blinkTime > 300L) {
            if (System.currentTimeMillis() - this.blinkTime > 600L) {
                this.blinkTime = System.currentTimeMillis();
            }
            return 0xFFFFFF;
        }
        String loc = null;
        int counts = 0;
        switch (this.type) {
            case LOCATIONTYPE: {
                if (DataHolder.getLatestChunkData() == null) {
                    return -1;
                }
                loc = DataHolder.getLatestChunkData().getLocationType(new ChunkPos(posX, posY));
                break;
            }
            case TICKET: {
                if (DataHolder.getLatestChunkData() == null) {
                    return -1;
                }
                loc = DataHolder.getLatestChunkData().getTickets(new ChunkPos(posX, posY));
                break;
            }
            case ENTITIES: {
                if (DataHolder.getLatestEntityData() == null) {
                    return -1;
                }
                counts = DataHolder.getLatestEntityData().getCountForChunk(new ChunkPos(posX, posY), this.entityFilter);
                break;
            }
            case TILEENTITIES: {
                if (DataHolder.getLatestTileEntityData() == null) {
                    return -1;
                }
                counts = DataHolder.getLatestTileEntityData().getCountForChunk(new ChunkPos(posX, posY), this.entityFilter);
            }
        }
        if (counts != 0) {
            float hue = counts > 100 ? 0.4f : (1.0f - (float)counts / 100.0f) * 0.4f;
            float saturation = 0.9f;
            float luminance = 1.0f;
            return Color.getHSBColor(hue, 0.9f, 1.0f).getRGB() + -16777216;
        }
        if (loc == null || loc.isEmpty() || loc.equals("[]")) {
            return 0;
        }
        if (this.renderFilter != null && !this.renderFilter.isEmpty() && !loc.equals(this.renderFilter)) {
            return 0;
        }
        if (this.colormap.containsKey(loc)) {
            return this.colormap.get(loc);
        }
        float hue = this.random.nextFloat();
        float saturation = 0.9f;
        float luminance = 1.0f;
        int color = Color.getHSBColor(hue, 0.9f, 1.0f).getRGB() + -16777216;
        this.colormap.put(loc, color);
        return color;
    }

    @Override
    public void addOffset(double x, double y) {
        this.XOffset = (int)((long)this.XOffset + Math.round(x / (double)this.zoom));
        this.YOffset = (int)((long)this.YOffset + Math.round(y / (double)this.zoom));
    }

    @Override
    public void scroll(double x, double y, double delta, int centerX, int centerY) {
        double distX = x - (double)(centerX + this.defaultRenderOffsetX);
        double distY = y - (double)(centerY + this.defaultRenderOffsetY);
        distX /= (double)this.zoom;
        distY /= (double)this.zoom;
        if (delta > 0.0) {
            this.zoom *= 2.0f;
            this.XOffset = (int)((double)this.XOffset + distX / 2.0);
            this.YOffset = (int)((double)this.YOffset + distY / 2.0);
        } else {
            this.zoom /= 2.0f;
            this.XOffset = (int)((double)this.XOffset - distX);
            this.YOffset = (int)((double)this.YOffset - distY);
        }
    }

    public String getLocFor(int x, int y) {
        ChunkPos pos = this.getChunkFor(x, y);
        if (DataHolder.getLatestChunkData() == null) {
            return null;
        }
        return DataHolder.getLatestChunkData().getLocationType(pos);
    }

    public String getTicketsFor(int x, int y) {
        ChunkPos pos = this.getChunkFor(x, y);
        if (DataHolder.getLatestChunkData() == null) {
            return null;
        }
        return DataHolder.getLatestChunkData().getTickets(pos);
    }

    public String getEntityCountFor(int x, int y) {
        ChunkPos pos = this.getChunkFor(x, y);
        if (DataHolder.getLatestEntityData() == null) {
            return null;
        }
        return String.valueOf(DataHolder.getLatestEntityData().getCountForChunk(pos, this.entityFilter));
    }

    public String getTileEntityCountFor(int x, int y) {
        ChunkPos pos = this.getChunkFor(x, y);
        if (DataHolder.getLatestTileEntityData() == null) {
            return null;
        }
        return String.valueOf(DataHolder.getLatestTileEntityData().getCountForChunk(pos, this.entityFilter));
    }

    public ChunkPos getChunkFor(int x, int y) {
        double xPos = (float)(x - this.XTopLeft) + (float)this.XOffset * this.zoom;
        double yPos = (float)(y - this.YTopLeft) + (float)this.YOffset * this.zoom;
        int xiPos = (int)Math.round(xPos / (double)this.zoom);
        int yiPos = (int)Math.round(yPos / (double)this.zoom);
        this.hoveringX = xiPos;
        this.hoveringY = yiPos;
        return new ChunkPos(xiPos, yiPos);
    }

    public String getNameForLocationType(String s) {
        if (s == null) {
            return "Nothing yet";
        }
        switch (s) {
            case "ENTITY_TICKING": {
                return "Fully loaded and ticking (ENTITY_TICKING)";
            }
            case "TICKING": {
                return "Loaded but not ticking entities (TICKING)";
            }
            case "BORDER": {
                return "Loaded but not ticking (BORDER)";
            }
            case "INACCESSIBLE": {
                return "Loaded but not ticking (INACCESSIBLE)";
            }
            case "FULL": {
                return "Loaded but not ticking (FULL)";
            }
            case "PRIMED": {
                return "Prepared for loading (Chunk Primer)";
            }
            case "PARTIALLYGENERATED": {
                return "Partially generated";
            }
        }
        return "???";
    }

    @Override
    public void updateSelection(DropDownType ddtype, String s) {
        if (s.equals("all")) {
            s = "";
        }
        switch (ddtype) {
            case RENDERTYPES: {
                GridRenderType type = GridRenderType.getTypeByName(s);
                if (type == null) {
                    return;
                }
                this.setRenderType(type);
                this.setRenderFilter(null);
                DataHolder.resetFilters();
                this.entityFilter = "";
                this.screen.topDropDowns.forEach(x -> x.setEnabled(false));
                this.RENDERTYPES.setEnabled(true);
                switch (type) {
                    case LOCATIONTYPE: {
                        DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
                        DataHolder.requestUpdates(0, this.screen.dim, !this.firstEntity);
                        this.currentType = DataRequestType.LOADEDCHUNKDATA;
                        break;
                    }
                    case TICKET: {
                        DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
                        DataHolder.requestUpdates(0, this.screen.dim, !this.firstEntity);
                        this.TICKETS.setEnabled(true);
                        this.currentType = DataRequestType.LOADEDCHUNKDATA;
                        break;
                    }
                    case ENTITIES: {
                        DataHolder.setRequestType(DataRequestType.ENTITYDATA);
                        DataHolder.requestUpdates(0, this.screen.dim, !this.firstEntity);
                        this.currentType = DataRequestType.ENTITYDATA;
                        this.firstEntity = true;
                        this.ENTITIES.setEnabled(true);
                        this.entityFilter = "";
                        break;
                    }
                    case TILEENTITIES: {
                        DataHolder.setRequestType(DataRequestType.TILEENTITYDATA);
                        DataHolder.requestUpdates(0, this.screen.dim, !this.firstTileEntity);
                        this.currentType = DataRequestType.TILEENTITYDATA;
                        this.firstTileEntity = true;
                        this.TILEENTITIES.setEnabled(true);
                        this.entityFilter = "";
                    }
                }
                break;
            }
            case TICKETS: {
                this.setRenderFilter(s);
                break;
            }
            case ENTITIES: 
            case TILEENTITIES: {
                this.entityFilter = s;
            }
        }
    }

    @Override
    public boolean mouseClicked(double mx, double my, int mouseButton) {
        return false;
    }

    @Override
    public boolean mouseClickedOutside(double mx, double my, int centerX, int centerY) {
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return false;
    }
}

