/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.CustomFakePlayer;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.Network.RemoveEntitiesMessage;
import com.darkere.crashutils.Network.RemoveEntityMessage;
import com.darkere.crashutils.Network.TeleportMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class WorldUtils {
    public static List<ServerLevel> getWorldsFromDimensionArgument(CommandContext<CommandSourceStack> context) {
        ServerLevel world = null;
        try {
            world = DimensionArgument.m_88808_(context, (String)"dim");
        }
        catch (CommandSyntaxException | IllegalArgumentException throwable) {
            // empty catch block
        }
        ArrayList<ServerLevel> worlds = new ArrayList<ServerLevel>();
        if (world == null) {
            ((CommandSourceStack)context.getSource()).m_81377_().m_129785_().forEach(worlds::add);
        } else {
            worlds.add(world);
        }
        return worlds;
    }

    public static void teleportPlayer(Player player, Level startWorld, Level destWorld, BlockPos newPos) {
        if (player.f_19853_.f_46443_) {
            Network.sendToServer(new TeleportMessage((ResourceKey<Level>)startWorld.m_46472_(), (ResourceKey<Level>)destWorld.m_46472_(), newPos));
        }
        if (newPos.m_123342_() == 0) {
            LevelChunk chunk = destWorld.m_46745_(newPos);
            int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, newPos.m_123341_(), newPos.m_123343_());
            newPos = new BlockPos(newPos.m_123341_(), y, newPos.m_123343_());
        }
        if (startWorld != destWorld) {
            final BlockPos finalNewPos = newPos;
            player.changeDimension((ServerLevel)destWorld, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity entity1 = repositionEntity.apply(false);
                    entity1.m_6021_((double)finalNewPos.m_123341_(), (double)(finalNewPos.m_123342_() + 1), (double)finalNewPos.m_123343_());
                    return entity1;
                }
            });
        } else {
            player.m_6021_((double)newPos.m_123341_(), (double)(newPos.m_123342_() + 1), (double)newPos.m_123343_());
        }
    }

    public static boolean applyToPlayer(String playerName, MinecraftServer server, Consumer<ServerPlayer> consumer) {
        ServerPlayer player = server.m_6846_().m_11255_(playerName);
        if (player == null) {
            Optional profile = server.m_129927_().m_10996_(playerName);
            if (profile.isEmpty()) {
                return false;
            }
            CustomFakePlayer fakePlayer = new CustomFakePlayer(server.m_129880_(Level.f_46428_), (GameProfile)profile.get());
            CompoundTag nbt = server.f_129745_.m_78435_((Player)fakePlayer);
            if (nbt == null) {
                return false;
            }
            fakePlayer.m_20258_(nbt);
            consumer.accept((ServerPlayer)fakePlayer);
            server.f_129745_.m_78433_((Player)fakePlayer);
        } else {
            consumer.accept(player);
        }
        return true;
    }

    public static BlockPos getChunkCenter(ChunkPos pos) {
        int x = pos.m_45604_() + 8;
        int z = pos.m_45605_() + 8;
        return new BlockPos(x, 0, z);
    }

    public static void removeEntity(Level world, UUID id, boolean force) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.f_46443_) {
            Network.sendToServer(new RemoveEntityMessage((ResourceKey<Level>)world.m_46472_(), id, false, force));
            return;
        }
        Entity e = ((ServerLevel)world).m_8791_(id);
        if (e == null) {
            return;
        }
        if (force) {
            ((ServerLevel)world).removeEntityComplete(e, false);
        } else {
            e.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void removeEntityType(Level world, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, rl)) {
            return;
        }
        if (world.f_46443_) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.m_46472_(), rl, null, false, force));
            return;
        }
        ((ServerLevel)world).m_142646_().m_142273_().forEach(entity -> {
            if (!Objects.equals(entity.m_6095_().getRegistryName(), rl)) {
                return;
            }
            if (force) {
                ((ServerLevel)world).removeEntityComplete(entity, false);
            } else {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        });
    }

    public static void removeEntitiesInChunk(Level world, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, pos, rl)) {
            return;
        }
        if (world.f_46443_) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.m_46472_(), rl, pos, false, force));
            return;
        }
        Vec3 start = new Vec3((double)pos.m_45604_(), 0.0, (double)pos.m_45605_());
        Vec3 end = new Vec3((double)pos.m_45608_(), 255.0, (double)pos.m_45609_());
        world.m_6249_((Entity)null, new AABB(start, end), entity -> Objects.equals(entity.m_6095_().getRegistryName(), rl)).forEach(e -> {
            if (force) {
                ((ServerLevel)world).removeEntityComplete(e, false);
            } else {
                e.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        });
    }

    public static void removeTileEntity(Level world, UUID id, boolean force) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.f_46443_) {
            Network.sendToServer(new RemoveEntityMessage((ResourceKey<Level>)world.m_46472_(), id, true, force));
            return;
        }
        CrashUtils.runNextTick(wld -> {
            if (force) {
                world.m_46747_(TileEntityData.TEID.get((Object)id).pos);
                world.m_7471_(TileEntityData.TEID.get((Object)id).pos, false);
            } else {
                world.m_46747_(TileEntityData.TEID.get((Object)id).pos);
            }
        });
    }

    public static void removeTileEntityType(Level world, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, rl)) {
            return;
        }
        if (world.f_46443_) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.m_46472_(), rl, null, true, force));
            return;
        }
        for (TickingBlockEntity te : world.f_151512_) {
            if (!Objects.equals(te.m_142280_(), rl.toString())) continue;
            CrashUtils.runNextTick(wld -> {
                if (force) {
                    world.m_46747_(te.m_142689_());
                    world.m_7471_(te.m_142689_(), false);
                } else {
                    world.m_46747_(te.m_142689_());
                }
            });
        }
    }

    public static void removeTileEntitiesInChunk(Level world, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, pos, rl)) {
            return;
        }
        if (world.f_46443_) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.m_46472_(), rl, pos, true, force));
            return;
        }
        Vec3 start = new Vec3((double)pos.m_45604_(), 0.0, (double)pos.m_45605_());
        Vec3 end = new Vec3((double)pos.m_45608_(), 255.0, (double)pos.m_45609_());
        world.f_151512_.stream().filter(te -> Objects.equals(te.m_142280_(), rl.toString()) && new AABB(start, end).m_82390_(Vec3.m_82512_((Vec3i)te.m_142689_()))).forEach(te -> CrashUtils.runNextTick(wld -> {
            if (force) {
                world.m_46747_(te.m_142689_());
                world.m_7471_(te.m_142689_(), false);
            } else {
                world.m_46747_(te.m_142689_());
            }
        }));
    }
}

