/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.mixin;

import com.google.common.collect.ImmutableList;
import com.thevortex.allthetweaks.AllTheTweaks;
import java.util.List;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.internal.BrandingControl;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BrandingControl.class})
public class NameBrandsOnly {
    @Shadow(remap=false)
    private static List<String> brandings;
    @Shadow(remap=false)
    private static List<String> brandingsNoMC;

    @Overwrite(remap=false)
    private static void computeBranding() {
        if (brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)AllTheTweaks.DISPLAY);
            brd.add((Object)("Forge " + ForgeVersion.getVersion()));
            brd.add((Object)("Minecraft " + MCPVersion.getMCVersion()));
            brd.add((Object)("MCP " + MCPVersion.getMCPVersion()));
            int tModCount = ModList.get().size();
            brd.add((Object)ForgeI18n.parseMessage((String)"fml.menu.loadingmods", (Object[])new Object[]{tModCount}));
            brandings = brd.build();
            brandingsNoMC = brandings.subList(1, brandings.size());
        }
    }
}

