/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IEApi {
    public static List<? extends String> modPreference;
    public static HashMap<ResourceLocation, ItemStack> oreOutputPreference;
    public static int revolverTextureSheetID;
    public static HashMap<String, Integer[]> prefixToIngotMap;
    public static List<Supplier<MobEffect>> potions;
    public static List<Runnable> renderCacheClearers;
    public static List<Predicate<ItemStack>> forbiddenInCrates;

    public static ItemStack getPreferredTagStack(TagContainer tags, ResourceLocation name) {
        return oreOutputPreference.computeIfAbsent(name, rl -> {
            if (TagUtils.isNonemptyItemTag(tags, name)) {
                return new ItemStack((ItemLike)IEApi.getPreferredElementbyMod(TagUtils.getItemTag(tags, name).m_6497_()));
            }
            if (TagUtils.isNonemptyBlockTag(tags, name)) {
                return new ItemStack((ItemLike)IEApi.getPreferredElementbyMod(TagUtils.getBlockTag(tags, name).m_6497_()));
            }
            return ItemStack.f_41583_;
        }).m_41777_();
    }

    public static <T extends IForgeRegistryEntry<T>> T getPreferredElementbyMod(Collection<T> list) {
        return (T)IEApi.getPreferredElementbyMod(list, IForgeRegistryEntry::getRegistryName);
    }

    public static ItemStack getPreferredStackbyMod(Collection<ItemStack> list) {
        return IEApi.getPreferredElementbyMod(list, e -> e.m_41720_().getRegistryName());
    }

    public static <T> T getPreferredElementbyMod(Collection<T> list, Function<T, ResourceLocation> getName) {
        Object preferredStack = null;
        int currBest = modPreference.size();
        for (T stack : list) {
            String modId;
            int idx;
            ResourceLocation rl = getName.apply(stack);
            if (rl == null) continue;
            if (preferredStack == null) {
                preferredStack = stack;
            }
            if ((idx = modPreference.indexOf(modId = rl.m_135827_())) < 0) {
                idx = modPreference.size();
            }
            if (idx < currBest) {
                preferredStack = stack;
                currBest = idx;
                continue;
            }
            if (idx != currBest || rl.compareTo(getName.apply(preferredStack)) >= 0) continue;
            preferredStack = stack;
        }
        Preconditions.checkNotNull(preferredStack, (String)"No entry found in %s", list);
        return preferredStack;
    }

    public static ItemStack getPreferredStackbyMod(ItemStack[] array) {
        return IEApi.getPreferredElementbyMod(Lists.newArrayList((Object[])array), stack -> stack.m_41720_().getRegistryName());
    }

    public static boolean isAllowedInCrate(ItemStack stack) {
        for (Predicate<ItemStack> check : forbiddenInCrates) {
            if (!check.test(stack)) continue;
            return false;
        }
        return true;
    }

    public static String getCurrentVersion() {
        return ModList.get().getModFileById("immersiveengineering").versionString();
    }

    static {
        oreOutputPreference = new HashMap();
        prefixToIngotMap = new HashMap();
        renderCacheClearers = new ArrayList<Runnable>();
        forbiddenInCrates = new ArrayList<Predicate<ItemStack>>();
    }
}

