/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class BottlingMachineRecipe
extends MultiblockRecipe {
    public static RecipeType<BottlingMachineRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<BottlingMachineRecipe>> SERIALIZER;
    public final Ingredient input;
    public final FluidTagInput fluidInput;
    public final ItemStack output;
    public static Map<ResourceLocation, BottlingMachineRecipe> recipeList;

    public BottlingMachineRecipe(ResourceLocation id, ItemStack output, Ingredient input, FluidTagInput fluidInput) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.fluidInput = fluidInput;
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.fluidInput});
        this.outputList = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{this.output});
    }

    protected IERecipeSerializer<BottlingMachineRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static BottlingMachineRecipe findRecipe(ItemStack input, FluidStack fluid) {
        if (!input.m_41619_() && !fluid.isEmpty()) {
            for (BottlingMachineRecipe recipe : recipeList.values()) {
                if (!recipe.input.test(input) || !recipe.fluidInput.test(fluid)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

