/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import java.util.Collections;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

public class ClocheFertilizer
extends IESerializableRecipe {
    public static RecipeType<ClocheFertilizer> TYPE;
    public static RegistryObject<IERecipeSerializer<ClocheFertilizer>> SERIALIZER;
    public static Map<ResourceLocation, ClocheFertilizer> fertilizerList;
    public final Ingredient input;
    public final float growthModifier;

    public ClocheFertilizer(ResourceLocation id, Ingredient input, float growthModifier) {
        super(ItemStack.f_41583_, TYPE, id);
        this.input = input;
        this.growthModifier = growthModifier;
    }

    public float getGrowthModifier() {
        return this.growthModifier;
    }

    protected IERecipeSerializer<ClocheFertilizer> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public static float getFertilizerGrowthModifier(ItemStack stack) {
        for (ClocheFertilizer e : fertilizerList.values()) {
            if (!e.input.test(stack)) continue;
            return e.getGrowthModifier();
        }
        return 0.0f;
    }

    public static boolean isValidFertilizer(ItemStack stack) {
        return ClocheFertilizer.getFertilizerGrowthModifier(stack) > 0.0f;
    }

    static {
        fertilizerList = Collections.emptyMap();
    }
}

