/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class IEFinishedRecipe<R extends IEFinishedRecipe<R>>
implements FinishedRecipe {
    private final IERecipeSerializer<?> serializer;
    private final List<Consumer<JsonObject>> writerFunctions;
    private ResourceLocation id;
    protected JsonArray inputArray = null;
    protected int inputCount = 0;
    protected int maxInputCount = 1;
    protected JsonArray resultArray = null;
    protected int resultCount = 0;
    protected int maxResultCount = 1;
    protected JsonArray conditions = null;

    protected IEFinishedRecipe(IERecipeSerializer<?> serializer) {
        this.serializer = serializer;
        this.writerFunctions = new ArrayList<Consumer<JsonObject>>();
    }

    protected boolean isComplete() {
        return true;
    }

    public void build(Consumer<FinishedRecipe> out, ResourceLocation id) {
        Preconditions.checkArgument((boolean)this.isComplete(), (Object)"This recipe is incomplete");
        this.id = id;
        out.accept(this);
    }

    public R addWriter(Consumer<JsonObject> writer) {
        Preconditions.checkArgument((this.id == null ? 1 : 0) != 0, (Object)"This recipe has already been finalized");
        this.writerFunctions.add(writer);
        return (R)this;
    }

    public R addCondition(ICondition condition) {
        if (this.conditions == null) {
            this.conditions = new JsonArray();
            this.addWriter(jsonObject -> jsonObject.add("conditions", (JsonElement)this.conditions));
        }
        this.conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        return (R)this;
    }

    public R setTime(int time) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("time", (Number)time));
    }

    public R setEnergy(int energy) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("energy", (Number)energy));
    }

    public R setMultipleResults(int maxResultCount) {
        this.resultArray = new JsonArray();
        this.maxResultCount = maxResultCount;
        return this.addWriter(jsonObject -> jsonObject.add("results", (JsonElement)this.resultArray));
    }

    public R addMultiResult(JsonElement obj) {
        Preconditions.checkArgument((this.maxResultCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple results");
        Preconditions.checkArgument((this.resultCount < this.maxResultCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxResultCount + " results"));
        this.resultArray.add(obj);
        ++this.resultCount;
        return (R)this;
    }

    public R addResult(ItemLike itemProvider) {
        return this.addResult(new ItemStack(itemProvider));
    }

    public R addResult(ItemStack itemStack) {
        if (this.resultArray != null) {
            return this.addMultiResult((JsonElement)this.serializeItemStack(itemStack));
        }
        return this.addItem("result", itemStack);
    }

    public R addResult(Ingredient ingredient) {
        if (this.resultArray != null) {
            return this.addMultiResult(ingredient.m_43942_());
        }
        return this.addWriter(jsonObject -> jsonObject.add("result", ingredient.m_43942_()));
    }

    public R addResult(IngredientWithSize ingredientWithSize) {
        if (this.resultArray != null) {
            return this.addMultiResult(ingredientWithSize.serialize());
        }
        return this.addWriter(jsonObject -> jsonObject.add("result", ingredientWithSize.serialize()));
    }

    public R setUseInputArray(int maxInputCount, String key) {
        this.inputArray = new JsonArray();
        this.maxInputCount = maxInputCount;
        return this.addWriter(jsonObject -> jsonObject.add(key, (JsonElement)this.inputArray));
    }

    public R setUseInputArray(int maxInputCount) {
        return this.setUseInputArray(maxInputCount, "inputs");
    }

    public R addMultiInput(JsonElement obj) {
        Preconditions.checkArgument((this.maxInputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple inputs");
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxInputCount + " inputs"));
        this.inputArray.add(obj);
        ++this.inputCount;
        return (R)this;
    }

    public R addMultiInput(Ingredient ingredient) {
        return this.addMultiInput(ingredient.m_43942_());
    }

    public R addMultiInput(IngredientWithSize ingredient) {
        return this.addMultiInput(ingredient.serialize());
    }

    protected String generateSafeInputKey() {
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxInputCount + " inputs"));
        String key = this.maxInputCount == 1 ? "input" : "input" + this.inputCount;
        ++this.inputCount;
        return key;
    }

    public R addInput(ItemLike ... itemProviders) {
        if (this.inputArray != null) {
            return this.addMultiInput(Ingredient.m_43929_((ItemLike[])itemProviders));
        }
        return this.addIngredient(this.generateSafeInputKey(), itemProviders);
    }

    public R addInput(ItemStack ... itemStacks) {
        if (this.inputArray != null) {
            return this.addMultiInput(Ingredient.m_43927_((ItemStack[])itemStacks));
        }
        return this.addIngredient(this.generateSafeInputKey(), itemStacks);
    }

    public R addInput(Tag<Item> tag) {
        if (this.inputArray != null) {
            return this.addMultiInput(Ingredient.m_43911_(tag));
        }
        return this.addIngredient(this.generateSafeInputKey(), tag);
    }

    public R addInput(Ingredient input) {
        if (this.inputArray != null) {
            return this.addMultiInput(input);
        }
        return this.addIngredient(this.generateSafeInputKey(), input);
    }

    public R addInput(IngredientWithSize input) {
        if (this.inputArray != null) {
            return this.addMultiInput(input);
        }
        return this.addIngredient(this.generateSafeInputKey(), input);
    }

    public JsonObject serializeItemStack(ItemStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", stack.m_41720_().getRegistryName().toString());
        if (stack.m_41613_() > 1) {
            obj.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            obj.addProperty("nbt", stack.m_41783_().toString());
        }
        return obj;
    }

    protected R addSimpleItem(String key, ItemLike item) {
        return this.addWriter(json -> json.addProperty(key, item.m_5456_().getRegistryName().toString()));
    }

    public R addItem(String key, ItemLike item) {
        return this.addItem(key, new ItemStack(item));
    }

    public R addItem(String key, ItemStack stack) {
        Preconditions.checkArgument((!stack.m_41619_() ? 1 : 0) != 0, (Object)"May not add empty ItemStack to recipe");
        return this.addWriter(jsonObject -> jsonObject.add(key, (JsonElement)this.serializeItemStack(stack)));
    }

    public R addIngredient(String key, ItemLike ... itemProviders) {
        return this.addIngredient(key, Ingredient.m_43929_((ItemLike[])itemProviders));
    }

    public R addIngredient(String key, ItemStack ... itemStacks) {
        return this.addIngredient(key, Ingredient.m_43927_((ItemStack[])itemStacks));
    }

    public R addIngredient(String key, Tag<Item> tag) {
        return this.addIngredient(key, Ingredient.m_43911_(tag));
    }

    public R addIngredient(String key, Ingredient ingredient) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ingredient.m_43942_()));
    }

    public R addIngredient(String key, IngredientWithSize ingredient) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ingredient.serialize()));
    }

    public R addFluid(String key, FluidStack fluidStack) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ApiUtils.jsonSerializeFluidStack(fluidStack)));
    }

    public R addFluid(FluidStack fluidStack) {
        return this.addFluid("fluid", fluidStack);
    }

    public R addFluid(Fluid fluid, int amount) {
        return this.addFluid("fluid", new FluidStack(fluid, amount));
    }

    public R addFluidTag(String key, FluidTagInput fluidTag) {
        return this.addWriter(jsonObject -> jsonObject.add(key, fluidTag.serialize()));
    }

    public R addFluidTag(String key, Tag.Named<Fluid> fluidTag, int amount) {
        return this.addFluidTag(key, new FluidTagInput((Tag<Fluid>)fluidTag, amount, null));
    }

    public R addFluidTag(Tag.Named<Fluid> fluidTag, int amount) {
        return this.addFluidTag("fluid", new FluidTagInput((Tag<Fluid>)fluidTag, amount, null));
    }

    public void m_7917_(JsonObject jsonObject) {
        for (Consumer<JsonObject> writer : this.writerFunctions) {
            writer.accept(jsonObject);
        }
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return this.serializer;
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }

    protected static JsonObject serializeStackWithChance(IngredientWithSize ingredient, float chance, ICondition ... conditions) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", ingredient.serialize());
        if (conditions.length > 0) {
            JsonArray conditionArray = new JsonArray();
            for (ICondition condition : conditions) {
                conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            jsonObject.add("conditions", (JsonElement)conditionArray);
        }
        return jsonObject;
    }
}

