/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class RailgunHandler {
    public static List<Pair<Supplier<Ingredient>, IRailgunProjectile>> projectilePropertyMap = new ArrayList<Pair<Supplier<Ingredient>, IRailgunProjectile>>();

    public static IRailgunProjectile registerProjectile(Supplier<Ingredient> stack, IRailgunProjectile properties) {
        projectilePropertyMap.add((Pair<Supplier<Ingredient>, IRailgunProjectile>)Pair.of(stack, (Object)properties));
        return properties;
    }

    public static StandardRailgunProjectile registerStandardProjectile(Tag<Item> tag, double damage, double gravity) {
        return (StandardRailgunProjectile)RailgunHandler.registerProjectile(() -> Ingredient.m_43911_((Tag)tag), new StandardRailgunProjectile(damage, gravity));
    }

    public static StandardRailgunProjectile registerStandardProjectile(ItemStack stack, double damage, double gravity) {
        return (StandardRailgunProjectile)RailgunHandler.registerProjectile(() -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), new StandardRailgunProjectile(damage, gravity));
    }

    public static IRailgunProjectile getProjectile(ItemStack stack) {
        for (Pair<Supplier<Ingredient>, IRailgunProjectile> pair : projectilePropertyMap) {
            if (!((Ingredient)((Supplier)pair.getFirst()).get()).test(stack)) continue;
            return (IRailgunProjectile)pair.getSecond();
        }
        return null;
    }

    public static class StandardRailgunProjectile
    implements IRailgunProjectile {
        private final double damage;
        private final double gravity;
        private RailgunRenderColors colorMap;

        public StandardRailgunProjectile(double damage, double gravity) {
            this.damage = damage;
            this.gravity = gravity;
        }

        public StandardRailgunProjectile setColorMap(RailgunRenderColors map) {
            this.colorMap = map;
            return this;
        }

        public RailgunRenderColors getColorMap() {
            return this.colorMap;
        }

        @Override
        public double getGravity() {
            return this.gravity;
        }

        @Override
        public double getDamage(Level world, Entity target, @Nullable UUID shooter, Entity projectile) {
            return this.damage;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static interface IRailgunProjectile {
        default public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity defaultProjectile) {
            return defaultProjectile;
        }

        default public double getGravity() {
            return 1.0;
        }

        default public double getDamage(Level world, Entity target, @Nullable UUID shooter, Entity projectile) {
            return 0.0;
        }

        default public void onHitTarget(Level world, HitResult target, @Nullable UUID shooter, Entity projectile) {
        }

        default public double getBreakChance(@Nullable UUID shooter, ItemStack ammo) {
            return 0.25;
        }

        default public boolean isValidForTurret() {
            return false;
        }
    }

    public static class RailgunRenderColors {
        private final List<int[]> rings;
        private final int gradientLength;

        public RailgunRenderColors(int[] ... rings) {
            Preconditions.checkArgument((rings.length > 0 ? 1 : 0) != 0, (Object)"Railgun render colors can not be instantiated with no data");
            this.rings = Arrays.asList(rings);
            this.gradientLength = rings[0].length;
            for (int[] ring : rings) {
                Preconditions.checkArgument((ring.length == this.gradientLength ? 1 : 0) != 0, (Object)"All rings in Railgun render must have the same length");
            }
        }

        public RailgunRenderColors(int ... color) {
            this(new int[][]{color});
        }

        public int getRingCount() {
            return this.rings.size();
        }

        public int getGradientLength() {
            return this.gradientLength;
        }

        private static int[] splitRGB(int rgb) {
            return new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF};
        }

        public int[] getRingColor(int lengthIdx, int widthIdx) {
            return RailgunRenderColors.splitRGB(this.rings.get(lengthIdx)[widthIdx]);
        }

        public int[] getFrontColor(int widthIdx) {
            return RailgunRenderColors.splitRGB(this.rings.get(0)[widthIdx]);
        }

        public int[] getBackColor(int widthIdx) {
            return RailgunRenderColors.splitRGB(this.rings.get(this.rings.size() - 1)[widthIdx]);
        }
    }
}

