/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class TagUtils {
    public static Tag<Item> getItemTag(TagContainer tags, ResourceLocation key) {
        return tags.m_144452_(Registry.f_122904_).m_13404_(key);
    }

    public static Tag<Block> getBlockTag(TagContainer tags, ResourceLocation key) {
        return tags.m_144452_(Registry.f_122901_).m_13404_(key);
    }

    public static Collection<ResourceLocation> getTagsForItem(TagContainer tags, Item item) {
        return tags.m_144452_(Registry.f_122904_).m_13394_((Object)item);
    }

    public static Collection<ResourceLocation> getTagsForBlock(TagContainer tags, Block block) {
        return tags.m_144452_(Registry.f_122901_).m_13394_((Object)block);
    }

    public static boolean isInBlockOrItemTag(TagContainer tags, ItemStack stack, ResourceLocation oreName) {
        if (!TagUtils.isNonemptyBlockOrItemTag(tags, oreName)) {
            return false;
        }
        Tag<Item> itemTag = TagUtils.getItemTag(tags, oreName);
        if (itemTag != null && itemTag.m_6497_().contains(stack.m_41720_())) {
            return true;
        }
        Tag<Block> blockTag = TagUtils.getBlockTag(tags, oreName);
        return blockTag != null && blockTag.m_6497_().stream().map(ItemLike::m_5456_).anyMatch(i -> stack.m_41720_() == i);
    }

    public static boolean isNonemptyItemTag(TagContainer tags, ResourceLocation name) {
        Tag<Item> t = TagUtils.getItemTag(tags, name);
        return t != null && !t.m_6497_().isEmpty();
    }

    public static boolean isNonemptyBlockTag(TagContainer tags, ResourceLocation name) {
        Tag<Block> t = TagUtils.getBlockTag(tags, name);
        return t != null && !t.m_6497_().isEmpty();
    }

    public static boolean isNonemptyBlockOrItemTag(TagContainer tags, ResourceLocation name) {
        return TagUtils.isNonemptyBlockTag(tags, name) || TagUtils.isNonemptyItemTag(tags, name);
    }

    public static String getMatchingPrefix(TagContainer tags, ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(tags, stack)) {
            for (String componentType : componentTypes) {
                if (!name.m_135815_().startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static Collection<ResourceLocation> getMatchingTagNames(TagContainer tags, ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(TagUtils.getTagsForItem(tags, stack.m_41720_()));
        Block b = Block.m_49814_((Item)stack.m_41720_());
        if (b != Blocks.f_50016_) {
            ret.addAll(TagUtils.getTagsForBlock(tags, b));
        }
        return ret;
    }

    public static String[] getMatchingPrefixAndRemaining(TagContainer tags, ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(tags, stack)) {
            for (String componentType : componentTypes) {
                if (!name.m_135815_().startsWith(componentType)) continue;
                String material = name.m_135815_().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(TagContainer tags, ItemStack stack) {
        return tags.m_144452_(Registry.f_122904_).m_13404_(Tags.Items.INGOTS.m_6979_()).m_8110_((Object)stack.m_41720_());
    }

    public static Tag.Named<Item> createItemWrapper(ResourceLocation name) {
        return ItemTags.m_13194_((String)name.toString());
    }

    public static Tag.Named<Block> createBlockWrapper(ResourceLocation name) {
        return BlockTags.m_13116_((String)name.toString());
    }

    public static Tag.Named<Fluid> createFluidWrapper(ResourceLocation name) {
        return FluidTags.m_13134_((String)name.toString());
    }
}

