/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class WireCollisionData {
    private final Map<BlockPos, List<CollisionInfo>> blockToWires = new Object2ObjectOpenHashMap();
    private final GlobalWireNetwork net;
    private final boolean isRemote;

    WireCollisionData(GlobalWireNetwork net, boolean isRemote) {
        this.net = net;
        this.isRemote = isRemote;
    }

    public void addConnection(Connection conn) {
        if (!this.isRemote && !conn.isInternal()) {
            WireLogger.logger.info("Adding block data for {}", (Object)conn);
            if (!conn.blockDataGenerated) {
                WireLogger.logger.info("Raytracing for addition of {}", (Object)conn);
                if (this.net.getLocalNet(conn.getEndA()) != this.net.getLocalNet(conn.getEndB())) {
                    throw new AssertionError();
                }
                WireUtils.raytraceAlongCatenary(conn, p -> this.add(p.block(), new CollisionInfo(p.entersAt(), p.leavesAt(), conn, true)), p -> this.add(p.block(), new CollisionInfo(p.entersAt(), p.leavesAt(), conn, false)));
                conn.blockDataGenerated = true;
            }
        }
    }

    public void removeConnection(Connection conn) {
        WireLogger.logger.info("Removing block data for {}", (Object)conn);
        if (!this.isRemote && conn.blockDataGenerated) {
            WireLogger.logger.info("Raytracing for removal of {}", (Object)conn);
            WireUtils.raytraceAlongCatenary(conn, p -> this.remove(p.block(), conn), p -> this.remove(p.block(), conn));
            conn.blockDataGenerated = false;
        }
    }

    private void remove(BlockPos pos, Connection toRemove) {
        List existing = this.blockToWires.computeIfAbsent(pos, $ -> new ArrayList());
        existing.removeIf(i -> i.conn == toRemove);
        if (existing.isEmpty()) {
            this.blockToWires.remove(pos);
        }
    }

    private void add(BlockPos pos, CollisionInfo info) {
        List existing = this.blockToWires.computeIfAbsent(pos, $ -> new ArrayList());
        if (!existing.contains(info)) {
            existing.add(info);
        }
    }

    @Nonnull
    public Collection<CollisionInfo> getCollisionInfo(BlockPos pos) {
        ImmutableList ret = this.blockToWires.get(pos);
        if (ret == null) {
            ret = ImmutableList.of();
        }
        return ret;
    }

    public class CollisionInfo {
        @Nonnull
        public final Vec3 intersectA;
        @Nonnull
        public final Vec3 intersectB;
        @Nonnull
        public final Connection conn;
        public final boolean isInBlock;

        public CollisionInfo(@Nonnull Vec3 intersectA, @Nonnull Vec3 intersectB, Connection conn, boolean isInBlock) {
            this.intersectA = intersectA;
            this.intersectB = intersectB;
            this.conn = conn;
            this.isInBlock = isInBlock;
        }

        public LocalWireNetwork getLocalNet() {
            return this.conn.getContainingNet(WireCollisionData.this.net);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollisionInfo that = (CollisionInfo)o;
            if (this.isInBlock != that.isInBlock) {
                return false;
            }
            if (!this.intersectA.equals((Object)that.intersectA)) {
                return false;
            }
            if (!this.intersectB.equals((Object)that.intersectB)) {
                return false;
            }
            return this.conn.equals(that.conn);
        }

        public int hashCode() {
            int result = this.intersectA.hashCode();
            result = 31 * result + this.intersectB.hashCode();
            result = 31 * result + this.conn.hashCode();
            result = 31 * result + (this.isInBlock ? 1 : 0);
            return result;
        }
    }
}

