/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class SmartLightingQuad
extends BakedQuad {
    private static Field parent;
    private static Field blockInfo;
    private static Field pose;
    BlockPos blockPos;

    public SmartLightingQuad(int[] vertexDataIn, int tintIndexIn, Direction faceIn, TextureAtlasSprite spriteIn, BlockPos p) {
        super(vertexDataIn, tintIndexIn, faceIn, spriteIn, false);
        this.blockPos = p;
    }

    public void pipe(IVertexConsumer consumer) {
        if (consumer instanceof VertexLighterFlat) {
            super.pipe((IVertexConsumer)new SmartVertexLighter((VertexLighterFlat)consumer));
        } else {
            super.pipe(consumer);
        }
    }

    static {
        try {
            blockInfo = VertexLighterFlat.class.getDeclaredField("blockInfo");
            blockInfo.setAccessible(true);
            pose = VertexLighterFlat.class.getDeclaredField("pose");
            pose.setAccessible(true);
            parent = QuadGatheringTransformer.class.getDeclaredField("parent");
            parent.setAccessible(true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private class SmartVertexLighter
    extends VertexLighterFlat {
        private byte oldLightmapLength;

        public SmartVertexLighter(VertexLighterFlat base) {
            super(Minecraft.m_91087_().m_91298_());
            try {
                this.setParent((IVertexConsumer)parent.get(base));
                this.setTransform((PoseStack.Pose)pose.get(base));
                this.setVertexFormat(DefaultVertexFormat.f_85811_);
                BlockInfo info = (BlockInfo)blockInfo.get(base);
                this.setWorld(info.getLevel());
                this.setState(info.getState());
                this.setBlockPos(info.getBlockPos());
                this.updateBlockInfo();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
            BlockAndTintGetter world = this.blockInfo.getLevel();
            BlockPos here = SmartLightingQuad.this.blockPos.m_142022_(Math.floor((double)(x - normal[0] / 2.0f) + 0.5), Math.floor((double)(y - normal[1] / 2.0f) + 0.5), Math.floor((double)(z - normal[2] / 2.0f) + 0.5));
            lightmap[0] = (float)world.m_5518_().m_75814_(LightLayer.BLOCK).m_7768_(here) / 15.0f;
            lightmap[1] = (float)world.m_5518_().m_75814_(LightLayer.SKY).m_7768_(here) / 15.0f;
            this.oldLightmapLength = this.dataLength[this.lightmapIndex];
            this.dataLength[this.lightmapIndex] = 0;
        }

        protected void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
            this.dataLength[this.lightmapIndex] = this.oldLightmapLength;
            super.updateColor(normal, color, x, y, z, tint, multiplier);
        }
    }
}

