/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.models.connection.RenderCacheKey;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.mixin.accessors.client.RenderTypeAccess;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class BakedConnectionModel<T>
extends BakedIEModel {
    Lazy<TextureAtlasSprite> textureAtlasSprite = Lazy.of(() -> Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("immersiveengineering", "block/wire")));
    public static final Cache<ModelKey, SpecificConnectionModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    @Nullable
    private final BakedModel base;
    private final Either<ICacheKeyProvider<T>, T> extraCacheKey;
    private final ImmutableSet<String> layers;

    public BakedConnectionModel(@Nullable BakedModel basic, Collection<String> layers, T extraCacheKey) {
        this.base = basic;
        this.layers = ImmutableSet.copyOf(layers);
        this.extraCacheKey = Either.right(extraCacheKey);
    }

    public BakedConnectionModel(@Nullable BakedModel basic, Collection<String> layers, ICacheKeyProvider<T> extraCacheKey) {
        this.base = basic;
        this.layers = ImmutableSet.copyOf(layers);
        this.extraCacheKey = Either.left(extraCacheKey);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null && extraData.hasProperty(IEProperties.Model.CONNECTIONS)) {
            Object extraKey = this.extraCacheKey.map(ickp -> ickp.getKey(state, side, rand, extraData), Function.identity());
            RenderCacheKey ad = new RenderCacheKey(state, (ModelState)BlockModelRotation.X0_Y0, null, extraKey);
            HashSet<Connection.RenderData> data = new HashSet<Connection.RenderData>();
            IEProperties.ConnectionModelData orig = (IEProperties.ConnectionModelData)extraData.getData(IEProperties.Model.CONNECTIONS);
            assert (orig != null);
            for (Connection c : orig.connections()) {
                c.generateCatenaryData();
                ConnectionPoint here = c.getEndFor(orig.here());
                data.add(Connection.RenderData.make(c, c.getEndB().equals(here), BakedConnectionModel.getSolidVertexCountForSide(here, c, 16)));
            }
            ModelKey key = new ModelKey(data, ad, orig.here());
            try {
                SpecificConnectionModel ret = (SpecificConnectionModel)cache.get((Object)key, () -> new SpecificConnectionModel(key, (TextureAtlasSprite)this.textureAtlasSprite.get()));
                RenderType current = MinecraftForgeClient.getRenderType();
                ArrayList<BakedQuad> connectionQuads = new ArrayList<BakedQuad>(ret.getQuads(current));
                connectionQuads.addAll(this.getBaseQuads(current, state, side, rand, extraData));
                return connectionQuads;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.getBaseQuads(MinecraftForgeClient.getRenderType(), state, side, rand, extraData);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        if (this.base != null) {
            return this.base.getParticleIcon(data);
        }
        return ForgeModelBakery.White.instance();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private List<BakedQuad> getBaseQuads(RenderType currentLayer, BlockState state, Direction side, Random rand, IModelData data) {
        if (this.base != null && (currentLayer == null || this.layers.contains((Object)((RenderTypeAccess)currentLayer).getName()))) {
            return this.base.getQuads(state, side, rand, data);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        if (this.base == null) {
            return EmptyModelData.INSTANCE;
        }
        return this.base.getModelData(world, pos, state, tileData);
    }

    public static List<BakedQuad> convertConnectionFromBlockstate(BlockPos here, Set<Connection.RenderData> data, TextureAtlasSprite t) {
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        if (data == null) {
            return ret;
        }
        Vec3 dir = Vec3.f_82478_;
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        for (Connection.RenderData connData : data) {
            int color = connData.color();
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
            if (rgb[3] == 0.0f) {
                rgb[3] = 1.0f;
            }
            float radius = (float)(connData.type().getRenderDiameter() / 2.0);
            for (int segmentEndId = 1; segmentEndId <= connData.pointsToRenderSolid(); ++segmentEndId) {
                Vec3 cross;
                boolean vertical;
                int segmentStartId = segmentEndId - 1;
                Vec3 segmentEnd = connData.getPoint(segmentEndId);
                Vec3 segmentStart = connData.getPoint(segmentStartId);
                boolean bl = vertical = segmentEnd.f_82479_ == segmentStart.f_82479_ && segmentEnd.f_82481_ == segmentStart.f_82481_;
                if (!vertical) {
                    dir = segmentEnd.m_82546_(segmentStart);
                    cross = up.m_82537_(dir);
                    cross = cross.m_82490_((double)radius / cross.m_82553_());
                } else {
                    cross = new Vec3((double)radius, 0.0, 0.0);
                }
                Vec3[] vertices = new Vec3[]{segmentEnd.m_82549_(cross), segmentEnd.m_82546_(cross), segmentStart.m_82546_(cross), segmentStart.m_82549_(cross)};
                ret.add(ModelUtils.createSmartLightingBakedQuad(vertices, Direction.DOWN, t, rgb, false, here));
                ret.add(ModelUtils.createSmartLightingBakedQuad(vertices, Direction.UP, t, rgb, true, here));
                if (!vertical) {
                    cross = dir.m_82537_(cross);
                    cross = cross.m_82490_((double)radius / cross.m_82553_());
                } else {
                    cross = new Vec3(0.0, 0.0, (double)radius);
                }
                vertices = new Vec3[]{segmentEnd.m_82549_(cross), segmentEnd.m_82546_(cross), segmentStart.m_82546_(cross), segmentStart.m_82549_(cross)};
                ret.add(ModelUtils.createSmartLightingBakedQuad(vertices, Direction.WEST, t, rgb, false, here));
                ret.add(ModelUtils.createSmartLightingBakedQuad(vertices, Direction.EAST, t, rgb, true, here));
            }
        }
        return ret;
    }

    public static int getSolidVertexCountForSide(ConnectionPoint start, Connection conn, int totalPoints) {
        ArrayList<Integer> crossings = new ArrayList<Integer>();
        Vec3 lastPoint = conn.getPoint(0.0, start);
        for (int i = 1; i <= totalPoints; ++i) {
            Vec3 current = conn.getPoint((double)i / (double)totalPoints, start);
            if (BakedConnectionModel.crossesChunkBoundary(current, lastPoint, start.getPosition())) {
                crossings.add(i);
            }
            lastPoint = current;
        }
        boolean greater = conn.isPositiveEnd(start);
        if (crossings.size() > 0) {
            int index = crossings.size() / 2;
            if (crossings.size() % 2 == 0 && greater) {
                --index;
            }
            return (Integer)crossings.get(index) - (greater ? 0 : 1);
        }
        return greater ? totalPoints : 0;
    }

    public static boolean crossesChunkBoundary(Vec3 start, Vec3 end, BlockPos offset) {
        if (BakedConnectionModel.crossesChunkBorderSingleDim(start.f_82479_, end.f_82479_, offset.m_123341_())) {
            return true;
        }
        if (BakedConnectionModel.crossesChunkBorderSingleDim(start.f_82480_, end.f_82480_, offset.m_123342_())) {
            return true;
        }
        return BakedConnectionModel.crossesChunkBorderSingleDim(start.f_82481_, end.f_82481_, offset.m_123343_());
    }

    private static boolean crossesChunkBorderSingleDim(double a, double b, int offset) {
        return (int)Math.floor(a + (double)offset) >> 4 != (int)Math.floor(b + (double)offset) >> 4;
    }

    private record ModelKey(Set<Connection.RenderData> connections, RenderCacheKey state, BlockPos here) {
    }

    public static class SpecificConnectionModel {
        private final Lazy<List<BakedQuad>> connectionQuads = Lazy.concurrentOf(() -> BakedConnectionModel.convertConnectionFromBlockstate(key.here, key.connections, texture));

        public SpecificConnectionModel(ModelKey key, TextureAtlasSprite texture) {
        }

        @Nonnull
        public List<BakedQuad> getQuads(RenderType layer) {
            if (layer != RenderType.m_110451_()) {
                return ImmutableList.of();
            }
            return (List)this.connectionQuads.get();
        }
    }
}

