/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.UnbakedModelGeometry;
import blusunrize.immersiveengineering.client.models.connection.BakedConnectionModel;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class ConnectionLoader
implements IModelLoader<ConnectorModel> {
    public static final ResourceLocation LOADER_NAME = new ResourceLocation("immersiveengineering", "connector");

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        BakedConnectionModel.cache.invalidateAll();
    }

    @Nonnull
    public ConnectorModel read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        UnbakedModelGeometry model;
        JsonElement baseModel = modelContents.get("base_model");
        if (baseModel.isJsonObject()) {
            JsonObject baseModelData = modelContents.getAsJsonObject("base_model");
            ResourceLocation subloader = baseModelData.has("loader") ? new ResourceLocation(baseModelData.get("loader").getAsString()) : new ResourceLocation("minecraft", "elements");
            model = ModelLoaderRegistry.getModel((ResourceLocation)subloader, (JsonDeserializationContext)deserializationContext, (JsonObject)baseModelData);
        } else {
            model = new UnbakedModelGeometry((UnbakedModel)ForgeModelBakery.defaultModelGetter().apply(new ResourceLocation(baseModel.getAsString())));
        }
        Object layers = ImmutableList.of((Object)RenderType.m_110451_().toString());
        if (modelContents.has("layers") && modelContents.get("layers").isJsonArray()) {
            JsonArray arr = modelContents.get("layers").getAsJsonArray();
            layers = new ArrayList(arr.size());
            for (JsonElement ele : arr) {
                if (ele.isJsonPrimitive() && ele.getAsJsonPrimitive().isString()) {
                    layers.add(ele.getAsString());
                    continue;
                }
                throw new RuntimeException("Layers in wire models must be strings! Invalid value: " + ele.toString());
            }
        }
        return new ConnectorModel(model, (List<String>)layers);
    }

    public static class ConnectorModel
    implements IModelGeometry<ConnectorModel> {
        private static final ResourceLocation WIRE_LOC = new ResourceLocation("immersiveengineering".toLowerCase(Locale.ENGLISH) + ":block/wire");
        @Nullable
        private final IModelGeometry<?> baseModel;
        @Nonnull
        private final List<String> layers;

        public ConnectorModel(@Nullable IModelGeometry<?> baseModel, @Nonnull List<String> layers) {
            this.baseModel = baseModel;
            this.layers = layers;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel base = this.baseModel == null ? null : this.baseModel.bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
            if (base instanceof ICacheKeyProvider) {
                return new BakedConnectionModel(base, (Collection<String>)this.layers, (ICacheKeyProvider)base);
            }
            return new BakedConnectionModel<Unit>(base, this.layers, Unit.INSTANCE);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ArrayList<Object> ret = this.baseModel != null ? new ArrayList(this.baseModel.getTextures(owner, modelGetter, missingTextureErrors)) : new ArrayList<Material>();
            ret.add(new Material(InventoryMenu.f_39692_, WIRE_LOC));
            return ret;
        }
    }
}

