/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.client.models.obj.GeneralIEOBJModel;
import blusunrize.immersiveengineering.client.models.obj.GlobalTempData;
import blusunrize.immersiveengineering.client.models.obj.MaterialColorGetter;
import blusunrize.immersiveengineering.client.models.obj.MaterialSpriteGetter;
import blusunrize.immersiveengineering.client.models.obj.QuadListAdder;
import blusunrize.immersiveengineering.client.models.obj.TextureCoordinateRemapper;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallback;
import blusunrize.immersiveengineering.client.models.obj.callback.item.ItemCallback;
import blusunrize.immersiveengineering.client.models.split.PolygonUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.modelsplitter.model.Group;
import malte0811.modelsplitter.model.MaterialLibrary;
import malte0811.modelsplitter.model.Polygon;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;

public class SpecificIEOBJModel<T>
implements BakedModel {
    private final GeneralIEOBJModel<T> baseModel;
    @Nonnull
    private final IEOBJCallback<T> callback;
    private final T key;
    @Nullable
    private final ShaderCase shader;
    private final IEProperties.IEObjState state;
    @Nullable
    private final RenderType layer;
    private List<BakedQuad> quads;

    public SpecificIEOBJModel(GeneralIEOBJModel<T> baseModel, T key, @Nullable ShaderCase shader, @Nullable RenderType layer) {
        this.baseModel = baseModel;
        this.callback = baseModel.getCallback();
        this.key = key;
        this.shader = shader;
        this.state = this.callback.getIEOBJState(key);
        this.layer = layer;
    }

    @Nonnull
    public List<BakedQuad> m_6840_(@Nullable BlockState pState, @Nullable Direction pSide, @Nonnull Random pRand) {
        if (pSide != null) {
            return List.of();
        }
        if (this.quads == null) {
            this.quads = this.buildQuads();
        }
        return this.quads;
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        GlobalTempData.setActiveModel(this);
        return this.baseModel.m_7521_();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack transforms) {
        Transformation matrix = (Transformation)PerspectiveMapWrapper.getTransforms((ModelState)this.baseModel.getOwner().getCombinedTransform()).getOrDefault((Object)cameraTransformType, (Object)Transformation.m_121093_());
        matrix.push(transforms);
        ItemCallback.castOrDefault(this.callback).handlePerspective(this.key, GlobalTempData.getActiveHolder(), cameraTransformType, transforms);
        return this;
    }

    private List<BakedQuad> buildQuads() {
        List<Object> quads = Lists.newArrayList();
        for (Map.Entry<String, Group<MaterialLibrary.OBJMaterial>> groupName : this.baseModel.getGroups().entrySet()) {
            List<ShadedQuads> temp = this.addQuadsForGroup(groupName.getKey(), groupName.getValue(), true);
            quads.addAll(temp.stream().map(ShadedQuads::quadsInLayer).flatMap(Collection::stream).filter(Objects::nonNull).toList());
        }
        quads = this.callback.modifyQuads(this.key, (List<BakedQuad>)quads);
        return ImmutableList.copyOf((Collection)quads);
    }

    public List<ShadedQuads> addQuadsForGroup(String groupName, Group<MaterialLibrary.OBJMaterial> group, boolean allowCaching) {
        List cached;
        GeneralIEOBJModel.GroupKey<T> cacheKey = new GeneralIEOBJModel.GroupKey<T>(this.key, this.shader, this.layer, groupName);
        if (allowCaching && (cached = (List)this.baseModel.getGroupCache().getIfPresent(cacheKey)) != null) {
            return cached;
        }
        int numPasses = this.shader != null ? this.shader.getLayers().length : 1;
        ArrayList<ShadedQuads> ret = new ArrayList<ShadedQuads>();
        Transformation optionalTransform = this.baseModel.getSprite().m_6189_();
        optionalTransform = this.callback.applyTransformations(this.key, groupName, optionalTransform);
        Transformation transform = this.state.transform();
        MaterialSpriteGetter<T> spriteGetter = new MaterialSpriteGetter<T>(this.baseModel.getSpriteGetter(), groupName, this.callback, this.key, this.shader);
        MaterialColorGetter<T> colorGetter = new MaterialColorGetter<T>(groupName, this.callback, this.key, this.shader);
        TextureCoordinateRemapper coordinateRemapper = new TextureCoordinateRemapper(this.shader);
        if (this.state.visibility().isVisible(groupName) && this.callback.shouldRenderGroup(this.key, groupName, this.layer)) {
            for (int pass = 0; pass < numPasses; ++pass) {
                if (this.shader != null && !this.shader.shouldRenderGroupForPass(groupName, pass)) continue;
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                spriteGetter.setRenderPass(pass);
                colorGetter.setRenderPass(pass);
                coordinateRemapper.setRenderPass(pass);
                QuadListAdder modelBuilder = new QuadListAdder(quads::add, transform);
                this.addGroupQuads(group, this.baseModel.getOwner(), modelBuilder, spriteGetter, colorGetter, coordinateRemapper, optionalTransform);
                ShaderLayer layer = this.shader != null ? this.shader.getLayers()[pass] : new ShaderLayer(new ResourceLocation("missing/no"), -1){

                    @Override
                    public RenderType getRenderType(RenderType baseType) {
                        return baseType;
                    }
                };
                ret.add(new ShadedQuads(layer, quads));
            }
        }
        if (allowCaching) {
            this.baseModel.getGroupCache().put(cacheKey, ret);
        }
        return ret;
    }

    private void addGroupQuads(Group<MaterialLibrary.OBJMaterial> group, IModelConfiguration owner, IModelBuilder<?> modelBuilder, MaterialSpriteGetter<?> spriteGetter, MaterialColorGetter<?> colorGetter, TextureCoordinateRemapper coordinateRemapper, Transformation transform) {
        for (Polygon<MaterialLibrary.OBJMaterial> face : group.getFaces()) {
            MaterialLibrary.OBJMaterial mat = face.getTexture();
            if (mat == null) continue;
            TextureAtlasSprite texture = spriteGetter.apply(mat.name(), ModelLoaderRegistry.resolveTexture((String)mat.map_Kd(), (IModelConfiguration)owner));
            Vector4f colorTint = colorGetter.apply(mat.name(), new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
            Polygon<MaterialLibrary.OBJMaterial> remappedFace = coordinateRemapper.remapCoord(face);
            if (remappedFace == null) continue;
            modelBuilder.addGeneralQuad(PolygonUtils.toBakedQuad(remappedFace.getPoints(), new PolygonUtils.ExtraQuadData(texture, colorTint), transform.blockCenterToCorner(), false));
        }
    }

    public Map<String, Group<MaterialLibrary.OBJMaterial>> getGroups() {
        return this.baseModel.getGroups();
    }

    @Nonnull
    public IEOBJCallback<T> getCallback() {
        return this.callback;
    }

    public T getKey() {
        return this.key;
    }

    public record ShadedQuads(ShaderLayer layer, List<BakedQuad> quadsInLayer) {
    }
}

