/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.client.models.UnbakedModelGeometry;
import blusunrize.immersiveengineering.client.models.split.UnbakedSplitModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class SplitModelLoader
implements IModelLoader<UnbakedSplitModel> {
    public static final ResourceLocation LOCATION = new ResourceLocation("immersiveengineering", "basic_split");
    public static final String PARTS = "split_parts";
    public static final String BASE_MODEL = "base_model";
    public static final String BASE_LOADER = "base_loader";
    public static final String DYNAMIC = "dynamic";

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
    }

    @Nonnull
    public UnbakedSplitModel read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        UnbakedModelGeometry baseModel;
        if (modelContents.has(BASE_MODEL)) {
            baseModel = new UnbakedModelGeometry((UnbakedModel)ForgeModelBakery.defaultModelGetter().apply(new ResourceLocation(modelContents.get(BASE_MODEL).getAsString())));
        } else {
            ResourceLocation subloader = modelContents.has(BASE_LOADER) ? new ResourceLocation(modelContents.get(BASE_LOADER).getAsString()) : new ResourceLocation("minecraft", "elements");
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)subloader, (JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
        }
        JsonArray partsJson = modelContents.getAsJsonArray(PARTS);
        ArrayList<Vec3i> parts = new ArrayList<Vec3i>(partsJson.size());
        for (Object e : partsJson) {
            parts.add(this.fromJson(e.getAsJsonArray()));
        }
        BoundingBox box = this.pointBB((Vec3i)parts.get(0));
        for (Vec3i v : parts) {
            box.m_162386_(this.pointBB(v));
        }
        Vec3i size = new Vec3i(box.m_71056_(), box.m_71057_(), box.m_71058_());
        return new UnbakedSplitModel(baseModel, parts, modelContents.get(DYNAMIC).getAsBoolean(), size);
    }

    private Vec3i fromJson(JsonArray a) {
        return new Vec3i(a.get(0).getAsInt(), a.get(1).getAsInt(), a.get(2).getAsInt());
    }

    private BoundingBox pointBB(Vec3i point) {
        return new BoundingBox(new BlockPos(point));
    }
}

