/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GuiHelper {
    public static void drawColouredRect(int x, int y, int w, int h, int colour, MultiBufferSource buffers, PoseStack transform) {
        Matrix4f mat = transform.m_85850_().m_85861_();
        VertexConsumer worldrenderer = buffers.m_6299_(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        worldrenderer.m_142461_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF);
        worldrenderer.m_85982_(mat, (float)x, (float)(y + h), 0.0f).m_5752_();
        worldrenderer.m_85982_(mat, (float)(x + w), (float)(y + h), 0.0f).m_5752_();
        worldrenderer.m_85982_(mat, (float)(x + w), (float)y, 0.0f).m_5752_();
        worldrenderer.m_85982_(mat, (float)x, (float)y, 0.0f).m_5752_();
        worldrenderer.m_141991_();
    }

    public static void drawColouredRect(PoseStack transform, int x, int y, int w, int h, DyeColor dyeColor) {
        Matrix4f mat = transform.m_85850_().m_85861_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float[] color = dyeColor.m_41068_();
        bufferbuilder.m_85982_(mat, (float)x, (float)(y + h), 0.0f).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferbuilder.m_85982_(mat, (float)(x + w), (float)(y + h), 0.0f).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferbuilder.m_85982_(mat, (float)(x + w), (float)y, 0.0f).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferbuilder.m_85982_(mat, (float)x, (float)y, 0.0f).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferbuilder.m_141991_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void drawTexturedColoredRect(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        TransformingVertexBuilder innerBuilder = new TransformingVertexBuilder(builder, transform, DefaultVertexFormat.f_85811_);
        innerBuilder.m_142461_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * alpha));
        innerBuilder.setLight(LightTexture.m_109885_((int)15, (int)15));
        innerBuilder.setOverlay(OverlayTexture.f_118083_);
        innerBuilder.setNormal(1.0f, 1.0f, 1.0f);
        innerBuilder.m_5483_(x, y + h, 0.0).m_7421_(u0, v1).m_5752_();
        innerBuilder.m_5483_(x + w, y + h, 0.0).m_7421_(u1, v1).m_5752_();
        innerBuilder.m_5483_(x + w, y, 0.0).m_7421_(u1, v0).m_5752_();
        innerBuilder.m_5483_(x, y, 0.0).m_7421_(u0, v0).m_5752_();
        innerBuilder.m_141991_();
    }

    public static void drawTexturedRect(VertexConsumer builder, PoseStack transform, int x, int y, int w, int h, float picSize, int u0, int u1, int v0, int v1) {
        GuiHelper.drawTexturedColoredRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, (float)u0 / picSize, (float)u1 / picSize, (float)v0 / picSize, (float)v1 / picSize);
    }

    public static void drawRepeatedFluidSpriteGui(MultiBufferSource buffer, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = IERenderTypes.getGui(InventoryMenu.f_39692_);
        VertexConsumer builder = buffer.m_6299_(renderType);
        GuiHelper.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(VertexConsumer builder, PoseStack transform, FluidStack fluid, float x, float y, float w, float h) {
        TextureAtlasSprite sprite = ClientUtils.getSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
        int col = fluid.getFluid().getAttributes().getColor(fluid);
        int iW = sprite.m_118405_();
        int iH = sprite.m_118408_();
        if (iW > 0 && iH > 0) {
            GuiHelper.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
        }
    }

    public static void drawRepeatedSprite(VertexConsumer builder, PoseStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            GuiHelper.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h, PoseStack transform) {
        GuiHelper.drawSlot(x, y, w, h, 255, transform);
    }

    public static void drawSlot(PoseStack transform, int x, int y, int w, int h, int dark, int main, int light) {
        int minX = x + 8 - w / 2;
        int minY = y + 8 - h / 2;
        int maxX = minX + w;
        int maxY = minY + h;
        GuiComponent.m_93172_((PoseStack)transform, (int)minX, (int)(minY - 1), (int)maxX, (int)minY, (int)dark);
        GuiComponent.m_93172_((PoseStack)transform, (int)(minX - 1), (int)(minY - 1), (int)minX, (int)maxY, (int)dark);
        GuiComponent.m_93172_((PoseStack)transform, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)main);
        GuiComponent.m_93172_((PoseStack)transform, (int)minX, (int)maxY, (int)(maxX + 1), (int)(maxY + 1), (int)light);
        GuiComponent.m_93172_((PoseStack)transform, (int)maxX, (int)minY, (int)(maxX + 1), (int)maxY, (int)light);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha, PoseStack transform) {
        GuiHelper.drawSlot(transform, x, y, w, h, alpha << 24 | 0x373737, alpha << 24 | 0x8B8B8B, alpha << 24 | 0xFFFFFF);
    }

    public static void drawDarkSlot(PoseStack transform, int x, int y, int w, int h) {
        GuiHelper.drawSlot(transform, x, y, w, h, 0x77222222, 0x77111111, 0x77999999);
    }

    public static void renderItemWithOverlayIntoGUI(MultiBufferSource buffer, PoseStack transform, ItemStack stack, int x, int y) {
        transform.m_85836_();
        transform.m_85837_((double)x, (double)y, 100.0);
        transform.m_85836_();
        transform.m_85837_(8.0, 8.0, 0.0);
        transform.m_85841_(1.0f, -1.0f, 1.0f);
        transform.m_85841_(16.0f, 16.0f, 16.0f);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        ClientUtils.mc().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.f_118083_, transform, (MultiBufferSource)batchBuffer, 0);
        batchBuffer.pipe(buffer);
        transform.m_85849_();
        GuiHelper.renderDurabilityBar(stack, buffer, transform);
        transform.m_85849_();
    }

    public static void renderDurabilityBar(ItemStack stack, MultiBufferSource buffer, PoseStack transform) {
        if (!stack.m_41619_() && stack.m_41720_().m_142522_(stack)) {
            int width = stack.m_41720_().m_142158_(stack);
            int color = stack.m_41720_().m_142159_(stack);
            GuiHelper.draw(transform, buffer, 2, 13, 13, 2, 0, 0, 0);
            GuiHelper.draw(transform, buffer, 2, 13, width, 1, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        }
    }

    private static void draw(PoseStack transform, MultiBufferSource buffer, int x, int y, int width, int height, int red, int green, int blue) {
        VertexConsumer builder = buffer.m_6299_(IERenderTypes.ITEM_DAMAGE_BAR);
        transform.m_85836_();
        transform.m_85837_((double)x, (double)y, 0.0);
        Matrix4f mat = transform.m_85850_().m_85861_();
        builder.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(red, green, blue, 255).m_5752_();
        builder.m_85982_(mat, 0.0f, (float)height, 0.0f).m_6122_(red, green, blue, 255).m_5752_();
        builder.m_85982_(mat, (float)width, (float)height, 0.0f).m_6122_(red, green, blue, 255).m_5752_();
        builder.m_85982_(mat, (float)width, 0.0f, 0.0f).m_6122_(red, green, blue, 255).m_5752_();
        transform.m_85849_();
    }
}

