/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEMultiblockBlock;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireBlockEntity;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.ManualItem;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SimpleCapProvider;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.VanillaFurnaceHeater;
import blusunrize.immersiveengineering.common.wires.GlobalNetProvider;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;

public class EventHandler {
    public static HashSet<IEExplosion> currentExplosions = new HashSet();
    public static final Queue<Runnable> SERVER_TASKS = new ArrayDeque<Runnable>();
    public static Map<UUID, CrusherBlockEntity> crusherMap = new HashMap<UUID, CrusherBlockEntity>();
    public static Set<Class<? extends Mob>> listOfBoringBosses = new HashSet<Class<? extends Mob>>();

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        ImmersiveEngineering.proxy.onWorldLoad();
    }

    @SubscribeEvent
    public void onCapabilitiesAttachEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof AbstractMinecart) {
            event.addCapability(new ResourceLocation("immersiveengineering:shader"), (ICapabilityProvider)new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "minecart")));
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("immersiveengineering", "skyhook_data"), (ICapabilityProvider)new CapabilitySkyhookData.SimpleSkyhookProvider());
        }
    }

    @SubscribeEvent
    public void onCapabilitiesAttachWorld(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(ImmersiveEngineering.rl("wire_network"), (ICapabilityProvider)new GlobalNetProvider((Level)event.getObject()));
    }

    @SubscribeEvent
    public void onCapabilitiesAttachBlockEntity(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)object;
            event.addCapability(ImmersiveEngineering.rl("vanilla_furnace_heater"), new SimpleCapProvider<VanillaFurnaceHeater>(() -> ExternalHeaterHandler.CAPABILITY, new VanillaFurnaceHeater(furnace)));
        }
    }

    @SubscribeEvent
    public void onMinecartInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        AbstractMinecart cart = (AbstractMinecart)entity;
        if (stack.m_41720_() instanceof IShaderItem) {
            cart.getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
                wrapper.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                if (!player.f_19853_.f_46443_) {
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageMinecartShaderSync((Entity)cart, wrapper));
                }
            });
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.f_46443_) {
            GlobalWireNetwork.getNetwork(event.world).update(event.world);
            int numToRun = SERVER_TASKS.size();
            for (int i = 0; i < numToRun; ++i) {
                Runnable next = SERVER_TASKS.poll();
                if (next == null) continue;
                next.run();
            }
        }
        if (event.phase == TickEvent.Phase.START && !currentExplosions.isEmpty()) {
            Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
            while (itExplosion.hasNext()) {
                IEExplosion ex = itExplosion.next();
                ex.doExplosionTick();
                if (!ex.isExplosionFinished) continue;
                itExplosion.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        CrusherBlockEntity crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.getSource().m_19385_()) && (crusher = crusherMap.get(event.getEntityLiving().m_142081_())) != null) {
            for (ItemEntity item : event.getDrops()) {
                if (item == null || item.m_32055_().m_41619_()) continue;
                crusher.doProcessOutput(item.m_32055_());
            }
            crusherMap.remove(event.getEntityLiving().m_142081_());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && !event.getEntityLiving().m_6072_()) {
            Rarity r = Rarity.EPIC;
            for (Class<? extends Mob> boring : listOfBoringBosses) {
                if (!boring.isAssignableFrom(event.getEntityLiving().getClass())) continue;
                return;
            }
            ItemStack bag = new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(r));
            event.getDrops().add(new ItemEntity(event.getEntityLiving().f_19853_, event.getEntityLiving().m_20185_(), event.getEntityLiving().m_20186_(), event.getEntityLiving().m_20189_(), bag));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        Player player;
        ItemStack activeStack;
        if (event.getEntityLiving() instanceof Player && !(activeStack = (player = (Player)event.getEntityLiving()).m_21211_()).m_41619_() && activeStack.m_41720_() instanceof IEShieldItem && event.getAmount() >= 3.0f && Utils.canBlockDamageSource((LivingEntity)player, event.getSource())) {
            float amount = event.getAmount();
            ((IEShieldItem)activeStack.m_41720_()).hitShield(activeStack, player, event.getSource(), amount, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        float mod;
        int amp;
        if (event.getSource().m_19384_() && event.getEntityLiving().m_21124_((MobEffect)IEPotions.FLAMMABLE.get()) != null) {
            amp = event.getEntityLiving().m_21124_((MobEffect)IEPotions.FLAMMABLE.get()).m_19564_();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (("flux".equals(event.getSource().m_19385_()) || IEDamageSources.razorShock.equals(event.getSource()) || event.getSource() instanceof IEDamageSources.ElectricDamageSource) && event.getEntityLiving().m_21124_((MobEffect)IEPotions.CONDUCTIVE.get()) != null) {
            amp = event.getEntityLiving().m_21124_((MobEffect)IEPotions.CONDUCTIVE.get()).m_19564_();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (!event.isCanceled() && !event.getEntityLiving().m_6072_() && event.getAmount() >= event.getEntityLiving().m_21223_() && event.getSource().m_7639_() instanceof Player && ((Player)event.getSource().m_7639_()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof DrillItem) {
            Utils.unlockIEAdvancement((Player)event.getSource().m_7639_(), "main/secret_drillbreak");
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Vec3 motion = event.getEntity().m_20184_();
        if (event.getEntityLiving().m_21124_((MobEffect)IEPotions.STICKY.get()) != null) {
            motion = motion.m_82492_(0.0, (double)((float)(event.getEntityLiving().m_21124_((MobEffect)IEPotions.STICKY.get()).m_19564_() + 1) * 0.3f), 0.0);
        } else if (event.getEntityLiving().m_21124_((MobEffect)IEPotions.CONCRETE_FEET.get()) != null) {
            motion = Vec3.f_82478_;
        }
        event.getEntity().m_20256_(motion);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack powerpack;
        if (event.getEntityLiving() instanceof Player && !event.getEntityLiving().m_6844_(EquipmentSlot.CHEST).m_41619_() && ItemNBTHelper.hasKey(event.getEntityLiving().m_6844_(EquipmentSlot.CHEST), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getEntityLiving().m_6844_(EquipmentSlot.CHEST), "IE:Powerpack")).m_41619_()) {
            powerpack.m_41720_().onArmorTick(powerpack, event.getEntityLiving().m_20193_(), (Player)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        BlockEntity te;
        ItemStack current = event.getPlayer().m_21120_(InteractionHand.MAIN_HAND);
        if (!current.m_41619_() && current.m_41720_() == IEItems.Tools.DRILL.get() && event.getPlayer().m_19941_((Tag)FluidTags.f_13131_)) {
            if (IEItems.Tools.DRILL.get().getUpgrades(current).m_128471_("waterproof")) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            } else {
                event.setCanceled(true);
            }
        }
        if (event.getState().m_60734_() == IEBlocks.MetalDevices.RAZOR_WIRE.get() && current.m_41720_() != IEItems.Tools.WIRECUTTER.get()) {
            event.setCanceled(true);
            RazorWireBlockEntity.applyDamage(event.getEntityLiving());
        }
        if (event.getPos() != null && (te = event.getPlayer().m_20193_().m_7702_(event.getPos())) instanceof IEBlockInterfaces.IEntityProof && !((IEBlockInterfaces.IEntityProof)te).canEntityDestroy((Entity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (!event.getLeft().m_41619_() && event.getLeft().m_41720_() instanceof IDrillHead && ((IDrillHead)event.getLeft().m_41720_()).getHeadDamage(event.getLeft()) > 0 && !event.getRight().m_41619_() && event.getLeft().m_41720_().m_6832_(event.getLeft(), event.getRight())) {
            int cost;
            event.setOutput(event.getLeft().m_41777_());
            int repair = Math.min(((IDrillHead)event.getOutput().m_41720_()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().m_41720_()).getMaximumHeadDamage(event.getOutput()) / 4);
            for (cost = 0; repair > 0 && cost < event.getRight().m_41613_(); ++cost) {
                ((IDrillHead)event.getOutput().m_41720_()).damageHead(event.getOutput(), -repair);
                event.setCost(Math.max(1, repair / 200));
                repair = Math.min(((IDrillHead)event.getOutput().m_41720_()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().m_41720_()).getMaximumHeadDamage(event.getOutput()) / 4);
            }
            event.setMaterialCost(cost);
            if (event.getName() == null || event.getName().isEmpty()) {
                if (event.getLeft().m_41788_()) {
                    event.setCost(event.getCost() + 5);
                    event.getOutput().m_41787_();
                }
            } else if (!event.getName().equals(event.getLeft().m_41786_().getString())) {
                event.setCost(event.getCost() + 5);
                if (event.getLeft().m_41788_()) {
                    event.setCost(event.getCost() + 2);
                }
                event.getOutput().m_41714_((Component)new TextComponent(event.getName()));
            }
        }
    }

    @SubscribeEvent
    public void onBlockRightclick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        BlockState state = event.getWorld().m_8055_(pos);
        if (!(state.m_60734_() instanceof LecternBlock) || event.getPlayer() == null) {
            return;
        }
        BlockEntity tile = event.getWorld().m_7702_(pos);
        if (tile instanceof LecternBlockEntity && ((LecternBlockEntity)tile).m_59566_().m_41720_() instanceof ManualItem) {
            if (!event.getPlayer().m_6144_()) {
                if (event.getWorld().f_46443_) {
                    ImmersiveEngineering.proxy.openManual();
                }
                event.setCanceled(true);
            } else if (!event.getWorld().f_46443_) {
                Direction direction = (Direction)state.m_61143_((Property)LecternBlock.f_54465_);
                ItemStack itemstack = ((LecternBlockEntity)tile).m_59566_().m_41777_();
                float f = 0.25f * (float)direction.m_122429_();
                float f1 = 0.25f * (float)direction.m_122431_();
                ItemEntity itementity = new ItemEntity(event.getWorld(), (double)pos.m_123341_() + 0.5 + (double)f, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5 + (double)f1, itemstack);
                itementity.m_32060_();
                event.getWorld().m_7967_((Entity)itementity);
                ((LecternBlockEntity)tile).m_6211_();
                LecternBlock.m_54497_((Level)event.getWorld(), (BlockPos)pos, (BlockState)state, (boolean)false);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void breakLast(BlockEvent.BreakEvent event) {
        BlockEntity te;
        if (event.getState().m_60734_() instanceof IEMultiblockBlock && (te = event.getWorld().m_7702_(event.getPos())) instanceof MultiblockPartBlockEntity) {
            ((MultiblockPartBlockEntity)te).onlyLocalDissassembly = event.getWorld().m_6106_().m_6793_();
        }
    }

    static {
        listOfBoringBosses.add(WitherBoss.class);
    }
}

